//
//  ViewControllerWithText.m
//  NavigationTestApp
//
//  Created by Dobrin Dobrev on 11/9/11.
//  Copyright (c) 2011 __MyCompanyName__. All rights reserved.
//

#import "ViewControllerWithText.h"

@implementation ViewControllerWithText

- (id)initWithNibName:(NSString*)nibName isModal:(BOOL)isModalVar {
    self = [super initWithNibName:nibName bundle:nil];
    if (self) {
        isModal = isModalVar;
    }
    return self;
}

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}

- (void)didReceiveMemoryWarning
{
    // Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
    
    // Release any cached data, images, etc that aren't in use.
}

#pragma mark - View lifecycle

- (void)rightBarButtonAction {

}

- (void)leftBarButtonAction {

}

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    UIView *rightButton = [[UIView alloc] initWithFrame:CGRectMake(0.0, 0.0, 170.0, 30.0)];
    UIView *leftButton = [[UIView alloc] initWithFrame:CGRectMake(0.0, 0.0, 170.0, 30.0)];
    rightButton.backgroundColor = [UIColor redColor];
    leftButton.backgroundColor = [UIColor yellowColor];
//    
    [self.navigationItem setPrompt:@"hi, how are you?"];
//    
    self.navigationItem.rightBarButtonItem = [[UIBarButtonItem alloc] initWithCustomView:rightButton];
    self.navigationItem.leftBarButtonItem = [[UIBarButtonItem alloc] initWithCustomView:leftButton];
    [rightButton release];
    // Do any additional setup after loading the view from its nib.
}

- (void)viewWillAppear:(BOOL)animated {
    if (isModal) {
        textLabel.text = @"Modal";
    } else {
        textLabel.text = @"Not modal";
    }
    
    UINavigationController *navController = isModal ? 
    (UINavigationController*)self.parentViewController : self.navigationController;
    
    topVCTitleLabel.text = navController.topViewController.title;
    visibleVCTitleLabel.text = navController.visibleViewController.title;
    
}

- (void)viewDidUnload
{
    [super viewDidUnload];
    // Release any retained subviews of the main view.
    // e.g. self.myOutlet = nil;
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    // Return YES for supported orientations
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}

- (IBAction)hideClicked:(id)sender {
    if (isModal) {
        [self dismissModalViewControllerAnimated:YES];
    } else {
        [self.navigationController popViewControllerAnimated:YES];
    }
}

@end
