//
//  Controller.m
//  TranformationAnimationTestApp
//
//  Created by Dobrin Dobrev on 11/10/11.
//  Copyright (c) 2011 __MyCompanyName__. All rights reserved.
//

#import "Controller.h"

@implementation Controller

-(IBAction)scale:(id)sender {
    batmanPeter.transform = CGAffineTransformScale(batmanPeter.transform, 0.5, 0.5);
}
-(IBAction)rotate:(id)sender {
    batmanPeter.transform = CGAffineTransformRotate(batmanPeter.transform, M_PI_2);
    
}
-(IBAction)translate:(id)sender {
    batmanPeter.transform = CGAffineTransformTranslate(batmanPeter.transform, 100.0, -50.0);
    
}
-(IBAction)mScale:(id)sender {
    batmanPeter.transform = CGAffineTransformMakeScale(0.5, 0.5);
    
}
-(IBAction)mRotate:(id)sender {
    batmanPeter.transform = CGAffineTransformMakeRotation(M_PI);
    
}
-(IBAction)mTranslate:(id)sender {
    batmanPeter.transform = CGAffineTransformMakeTranslation(100.0, -50.0);
    
}
-(IBAction)identity:(id)sender {
    batmanPeter.transform = CGAffineTransformIdentity;
}

-(IBAction)toggleAnimations:(id)sender {
    if (normalView.tag == 1) {
        //animations view is shown                
        [UIView transitionFromView:animView toView:normalView duration:1.0 options:UIViewAnimationOptionTransitionFlipFromBottom completion:NULL];
        
    } else {
        //normal view is shown
        animView.alpha = 1.0;
        [UIView transitionWithView:normalView duration:1.0 options:UIViewAnimationOptionTransitionFlipFromTop |  UIViewAnimationOptionTransitionCurlUp
                        animations:^{
        }completion:^(BOOL finished){
            [normalView removeFromSuperview];
            [viewController.view addSubview:animView];            
        }];
        
    }
    
    
    normalView.tag = 1 - normalView.tag;
    animView.tag = 1 - animView.tag;
}

-(IBAction)scaleAnim:(id)sender {
    [UIView animateWithDuration:1.0 animations:^{
        batmanPeterAnim.transform = CGAffineTransformScale(batmanPeterAnim.transform, 0.5, 0.5);
    }];    
}

-(IBAction)rotateAnim:(id)sender {
    [UIView animateWithDuration:1.0 animations:^{
        batmanPeterAnim.transform = CGAffineTransformRotate(batmanPeterAnim.transform, 0.9*(M_PI*2));
    }];
    //batmanPeterAnim
}

-(IBAction)translateAnim:(id)sender {
    [UIView animateWithDuration:1.0 animations:^{
        batmanPeterAnim.transform = CGAffineTransformTranslate(batmanPeterAnim.transform, 100.0, -50.0);
    }];    
}

-(IBAction)mScaleAnim:(id)sender {
    [UIView animateWithDuration:1.0 animations:^{
        batmanPeterAnim.transform = CGAffineTransformMakeScale(0.5, 0.5);
    }];    
}

-(IBAction)mRotateAnim:(id)sender {
    [UIView animateWithDuration:1.0 animations:^{
        batmanPeterAnim.transform = CGAffineTransformMakeRotation(M_PI_2);
    }];    
}

-(IBAction)mTranslateAnim:(id)sender {
    [UIView animateWithDuration:1.0 animations:^{
        batmanPeterAnim.transform = CGAffineTransformMakeTranslation(100.0, -50.0);
    }];    
}

-(IBAction)identityAnim:(id)sender {
    [UIView animateWithDuration:10.0 animations:^{
        batmanPeterAnim.transform = CGAffineTransformIdentity;
    }];    
}


@end
