package net.asteasolutions.aos;

import android.app.Activity;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.GestureDetector;
import android.view.GestureDetector.OnGestureListener;
import android.view.GestureDetector.SimpleOnGestureListener;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnTouchListener;
import android.widget.TextView;

public class UserInteractionActivity extends Activity {
	
	private TextView textView;
	
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);

        // Implement the gesture listener. We extend SimpleOnGestureListener
        // so we don't have to implement all methods in OnGestureListener.
        OnGestureListener gestureListener = new SimpleOnGestureListener() {
        	@Override
        	public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        		showGesture("Fling");
        		return true;
        	}
        	
        	@Override
        	public boolean onDoubleTap(MotionEvent e) {
        		showGesture("Double Tap");
        		return true;
        	}
        	
        	@Override
        	public void onLongPress(MotionEvent e) {
        		showGesture("Long Press");
        	}
        };
        
        // Create a GestureDetector with our gesture listener. It will detect
        // gestures and notify the listener when appropriate.
        final GestureDetector gestureDetector = new GestureDetector(gestureListener);
        
        // Get a reference to the view for which we will detect gestures
        textView = (TextView) findViewById(R.id.textView);
        
        // Register a touch listener for the view
        textView.setOnTouchListener(new OnTouchListener() {
			@Override
			public boolean onTouch(View view, MotionEvent event) {
				// Pass the touch events to the gesture detector so it can read them
				// and detect the gestures.
				gestureDetector.onTouchEvent(event);
				
				// We must always return true in order to receive full gestures.
				// E.g. if the user performs a fling, we should receive events
				// with the following actions: DOWN, a bunch of MOVEs, UP.
				// If we return false here, we will only receive DOWN. Then Android
				// considers we are not interested in this gesture and doesn't send
				// us the rest of the events for it.
				return true;
			}
		});
    }
    
    
    
    /* Ignore this part. It will be explained in lecture 7 */
    /* package */ void showGesture(String gesture) {
    	textView.setText(gesture + "!");
		handler.removeMessages(0);
		handler.sendEmptyMessageDelayed(0, 1000);
    }
    
    private Handler handler = new Handler() {
    	public void handleMessage(Message msg) {
			textView.setText(R.string.invite);
    	}
    };
}