package net.asteasolutions.aos;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;

public class SignUpActivity extends Activity {

	OnClickListener mOnClickListener = new OnClickListener() {
		
		@Override
		public void onClick(View v) {
			EditText usernameEditText = (EditText) findViewById(R.id.editTxt_username);
			String username = usernameEditText.getText().toString();
			
			if (username != null && !username.equals("")) {
				Intent data = new Intent("");
				data.putExtra("net.asteasolutions.aos.selectedUsername", username);
				setResult(RESULT_OK, data);
				finish();
			}
		}
	};
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		
		super.onCreate(savedInstanceState);
		
		setContentView(R.layout.sign_up);
		
		Intent i = getIntent();
		String username = i.getExtras().getString("net.asteasolutions.aos.username");
		EditText editTextUsername = (EditText) findViewById(R.id.editTxt_username);
		editTextUsername.setText(username);
		
		Button createUserButton = (Button) findViewById(R.id.btn_createAccount);
		createUserButton.setOnClickListener(mOnClickListener);
	}
}
