//
//  ViewController.m
//  FMI_seminar_UI
//
//  Created by Plamen Gerov on 11/15/11.
//  Copyright (c) 2011 __MyCompanyName__. All rights reserved.
//

#import "ViewController.h"

@implementation ViewController

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Release any cached data, images, etc that aren't in use.
}


//NOTE: pragma mark makes the method list (in a falling list right above the code window, last on the breadcrumbs path) more readable
#pragma mark - View lifecycle

- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view, typically from a nib.
    
    
    //NOTE: load the image for the imageView
    NSString* path =
    [[NSBundle mainBundle] pathForResource:@"google_docs" ofType:@"png"];
    UIImage* myImage = [UIImage imageWithContentsOfFile:path];
    imageView.image = myImage;
    
    //NOTE: any changes to the components can be done programatically in viewDidLoad (or also in loadView, granted they are created)
    scrollView.backgroundColor = [UIColor greenColor];
    scrollView.contentSize = CGSizeMake(scrollView.frame.size.width * 3, scrollView.frame.size.height);
    scrollView.showsVerticalScrollIndicator = NO;
    scrollView.pagingEnabled = YES; //NOTE: try it with pagingEnabled = NO
    
    //NOTE: now we add three colored pages to the scrollView, to distinguish the "pages"
    blackView = nil;
    CGFloat scrollWidth = scrollView.frame.size.width;
    CGFloat scrollHeight = scrollView.frame.size.height;
    for (int i = 0; i < 3; i++)
    {
        UIView* view = [[UIView alloc] initWithFrame:CGRectMake(i*scrollWidth, 0, scrollWidth, scrollHeight)];
        if (blackView == nil)
        {
            //NOTE: we will keep a reference to the first page in a member called blackView, in order to zoom it later
            blackView = view;
            [blackView retain]; //NOTE: blackView is not a retain property, we must retain it ourselves
        }
        [scrollView addSubview:view];
        view.backgroundColor = [UIColor colorWithRed:i*0.25f green:i*0.25f blue:i*0.25f alpha:1.0f];
        [view release]; //NOTE: we don't need the view reference anymore, it's retained by the scrollView as a subview
    }

    //NOTE: enable zooming on the scrollView
    scrollView.minimumZoomScale = 1.0f;
    scrollView.maximumZoomScale = 4.0f;
    
    //NOTE: imageView and picker are subviews of the scrollView because we made them so in the InterfaceBuilder/Storyboard
    //now we take them up one level and make them children of the blackView (they were siblings and underneath it before)
    [blackView addSubview:imageView];
    [blackView addSubview:picker];
    
    //NOTE: the slider must represent the zoom factor, so we match it to the zoomScale of the scrollView
    slider.minimumValue = 1.0f;
    slider.maximumValue = 4.0f;
    slider.value = 1.0f;
    slider.continuous = YES; //NO; NOTE: try it out
    
    //NOTE: dynamically creating the components on the second page
    
    UIWebView* wv = [[UIWebView alloc] initWithFrame:CGRectMake(scrollWidth + 50, 50, 200, 200)];
    webView = [wv retain];
    NSURL* myURL = [NSURL fileURLWithPath:[[NSBundle mainBundle] pathForResource:@"my" ofType:@"html"]];
    NSURLRequest* myRequest = [NSURLRequest requestWithURL:myURL];
    [webView loadRequest:myRequest];
    [wv release];
    
    //NOTE: pay attention to the memory management routines above. We need to retain the webview explicitly, because
    //webView is not a property, but just an ivar (member variable). We will release the webView in the dealloc method.
    //But we also need to release the created webview once here, to make up for the call to alloc. Calling retain and release on
    //the ivar at the same place will work but is confusing. So we use the pattern outlined above.
    //Note that we didn't need to go roundabout in the case of "view" and "blackView" above - we already had a variable (view)
    //that takes on the role of "wv" here.
    
    //NOTE: note also that if webView were declared as retain property, we should/could have used self.webView = wv, instead of 
    //webView = [wv retain];
    
    button = [UIButton buttonWithType:UIButtonTypeRoundedRect];
    [button setTitle:@"JS click" forState:UIControlStateNormal];
    button.frame = CGRectMake(scrollWidth+50, 350, 100, 30);
    [button retain];
    //NOTE: no need for release here, because button objects are autoreleased
    
    webView.delegate = self;
    //NOTE: don't forget to set the delegate
    
    [scrollView addSubview:webView];
    [scrollView addSubview:button];
    //NOTE: adding the components to the scrollView
    
    //NOTE: attach action handlers to components
    [button addTarget:self action:@selector(buttonClicked) forControlEvents:UIControlEventTouchDown];
    [slider addTarget:self action:@selector(sliderChanged) forControlEvents:UIControlEventValueChanged];
    //NOTE: we don't addTarget to the pageControl. Its action handler is connected from InterfaceBuilder (see on the storyboard).
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    // Return YES for supported orientations
    if ([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPhone) {
        return (interfaceOrientation != UIInterfaceOrientationPortraitUpsideDown);
        //NOTE: forbid turning upside down on iPhone/iPod
    } else {
        return YES;
    }
}

- (void)viewDidUnload
{
    [super viewDidUnload];
    // Release any retained subviews of the main view.
    // e.g. self.myOutlet = nil;
}

-(void)dealloc
{
    [button release];
    [webView release];
    [blackView release];
    //NOTE: the rest of the components are managed by the XIB and we don't care about their memory
}

#pragma mark - UIPickerDelegate methods

-(NSInteger)numberOfComponentsInPickerView:(UIPickerView *)pickerView
{
    return 2;
}

-(NSInteger)pickerView:(UIPickerView *)pickerView numberOfRowsInComponent:(NSInteger)component
{
    return 3;
}

-(NSString*)pickerView:(UIPickerView *)pickerView titleForRow:(NSInteger)row forComponent:(NSInteger)component
{
    return [NSString stringWithFormat:@"row %d, component %d",row,component];
}

#pragma mark - UIScrollViewDelegate methods

-(void)scrollViewDidEndZooming:(UIScrollView *)scrollView withView:(UIView *)view atScale:(float)scale
{
    slider.value = self->scrollView.zoomScale;
    //NOTE: using self-> here in order to access the scrollView member (and not to the scrollView parameter which hides the member)
    //this is not really necessary since they are the same object, but otherwise we get a warning (see the method below)
    //another option is to rename the parameter
}

-(void)scrollViewDidZoom:(UIScrollView *)scrollView
{
    slider.value = scrollView.zoomScale;
    //NOTE: this warning is left for illustration
}

-(void)scrollViewDidEndDragging:(UIScrollView *)scrollView1 willDecelerate:(BOOL)decelerate
{
    pageControl.currentPage = round(scrollView.contentOffset.x /scrollView.frame.size.width);
    //NOTE: this isn't exact but illustrates the idea
}

-(UIView*)viewForZoomingInScrollView:(UIScrollView *)scrollView
{
    return blackView;
}

#pragma mark - UIWebViewDelegate methods

-(BOOL)webView:(UIWebView *)webView shouldStartLoadWithRequest:(NSURLRequest *)request navigationType:(UIWebViewNavigationType)navigationType
{
    if ([request.URL.scheme isEqualToString:@"hey"]) //NOTE: make sure we called this from the JS function
    {
        //NOTE: we can call arbitrary Obj-C code
        scrollView.backgroundColor = [UIColor blueColor];
        return NO; //NOTE: it's important to return NO, else the webview would try to load the non-existing URL
    }
    return YES;   
}


#pragma mark - Action handlers

-(void)buttonClicked
{
    [webView stringByEvaluatingJavaScriptFromString:@"testJS();"]; //NOTE: calling Javascript from Objective-C
}

- (IBAction)pageControlValueChanged:(id)sender { //NOTE: this method is IBAction so that it can be connected from InterfaceBuilder
    int currentPage = pageControl.currentPage;
    scrollView.contentOffset = 
            CGPointMake(currentPage*scrollView.frame.size.width, 0); //NOTE: scroll programmatically the scrollView
}

-(void)sliderChanged
{
    scrollView.zoomScale = slider.value; //NOTE: zoom programmatically
}


@end
