#include <stdio.h>
#include <stdlib.h>

#define bool  int
#define true  1
#define false 0

void swap(int * x, int * y) {
  int z = * x;
  * x = * y;
  * y = z;
}

#define n 8
// n must be at least 5

typedef bool Graph[n][n]; // symmetric adjacency matrix;
// values 'false' assumed on the main diagonal

bool can_be_body[n];
bool can_be_sting[n];

void InitCanBeArrays() {
   for (int k = 0; k < n; k++) {
      can_be_body[k] = true;
      can_be_sting[k] = true;
   }
}

int Degree(Graph G, int v, int * v11, int * v12, int * v0) {
   int deg = 0;
   for (int k = 0; k < n; k++) {
      if (G[k][v]) {
         deg++;
         can_be_sting[k] = false; // correct <=> v is a foot
         switch (deg) {
            case 1: * v11 = k; break;
            case 2: * v12 = k; break;
         }
      }
      else if (k != v) {
         can_be_body[k] = false; // correct <=> v is a foot
         * v0 = k;
      }
   }
   return deg;
}

#define TheOtherVertex(v, v1, v2)  (((v) == (v2)) ? (v1) : (v2))

int FindNextCandidate(bool * arr, int index) {
   if (index < -1)
      index = -1;
   do
      index++;
   while (index < n && !arr[index]);
   return (index < n) ? index : -1;
}

int FindSting(Graph G) {
  int b = FindNextCandidate(can_be_body, -1);
  int s = FindNextCandidate(can_be_sting, -1);
  if (b == -1 || s == -1)
    return -1; // no sting or no body
  do {
     if (G[b][s]) {
        s = FindNextCandidate(can_be_sting, s); // sting <> s
        if (s == -1)
          return -1;
     }
     else
        b = FindNextCandidate(can_be_body, b); // body <> b unless sting = s
  } while (b != -1);
  // the body is omitted, but the sting is not
  return s; // sting = s unless the graph is not a scorpion
}

bool IsScorpion(Graph G) {
   int v, v11, v12, v0, body, sting;
   InitCanBeArrays();
   v = 1;
   int d = Degree(G, v, &v11, &v12, &v0);
   if (d == n-2) {
      body = v;
      sting = v0;
      if (Degree(G, sting, &v11, &v12, &v0) != 1)
         return false;
      return (Degree(G, sting, &v11, &v12, &v0) == 2);
   }
   if (d == 1) {
      sting = v;
      v = v11;
      d = Degree(G, v, &v11, &v12, &v0);
      if (d == n-2) {
         body = v;
         sting = v0;
         if (Degree(G, sting, &v11, &v12, &v0) != 1)
            return false;
         return (Degree(G, sting, &v11, &v12, &v0) == 2);
      }
      if (d == 2) {
         body = TheOtherVertex(sting, v11, v12);
         return (Degree(G, body, &v11, &v12, &v0) == n-2);
      }
      return false;
   }
   if (d == 2) {
      body = v11;  // not certain yet
      sting = v12; // not certain yet
      d = Degree(G, sting, &v11, &v12, &v0);
      if (d == 1) {
         // the sting and tail are now certain
         return (Degree(G, body, &v11, &v12, &v0) == n-2);
      }
      if (d == n-2) {
         swap(&sting, &body);
         // the body and tail are now certain
         return (Degree(G, sting, &v11, &v12, &v0) == 1);
      }
   }
   // v is a foot => can_be_... arrays contain correct information
   sting = FindSting(G);
   // can_be_... arrays are not necessary any more
   if (sting == -1)
      return false;
   d = Degree(G, sting, &v11, &v12, &v0);
   if (d != 1)
      return false;
   v = v11; // v = tail
   d = Degree(G, v, &v11, &v12, &v0);
   if (d != 2)
      return false;
   body = TheOtherVertex(sting, v11, v12);
   d = Degree(G, body, &v11, &v12, &v0);
   return (d == n-2);
}

void CheckAdjacencyMatrix(Graph G, int testNumber) {
   for (int i = 0; i < n; i++)
      for (int j = 0; j < n; j++)
         if (G[i][j] != G[j][i]) {
            printf("Adjacency matrix not symmetric: test number %d.\n\n", testNumber);
            exit(testNumber);
         }
   for (i = 0; i < n; i++)
      if (G[i][i]) {
         printf("Adjacency matrix contains loop: test number %d.\n\n", testNumber);
         exit(testNumber);
      }
}

bool TestCase1() {
   Graph G;
   int i, j;
   for (i = 0; i < n; i++) {
      for (j = 0; j < n; j++) {
         G[i][j] = (i == j) ? false : (
            i <  n / 2 && j <  n / 2 ||
            i >= n / 2 && j >= n / 2 ||
            i == n / 2 && j == i + 1 ||
            j == n / 2 && i == j + 1
         );
      }
   };
   CheckAdjacencyMatrix(G, 1);
   return (IsScorpion(G) == false); // no sting
}

bool TestCase2() {
   Graph G;
   int i, j, m;
   m = n-2;
   for (i = 0; i < m; i++) {
      for (j = 0; j < m; j++) {
         G[i][j] = (i == j) ? false : (
            i <  m / 2 && j <  m / 2 ||
            i >= m / 2 && j >= m / 2 ||
            i == m / 2 && j == i + 1 ||
            j == m / 2 && i == j + 1
         );
      }
   };
   for (i = 0; i < n - 1; i++)
      G[i][n-3] = G[n-3][i] = true;
   G[n-1][n-3] = G[n-3][n-1] = false;
   for (i = 0; i < n; i++)
      G[i][n-2] = G[n-2][i] = false;
   G[n-3][n-2] = G[n-2][n-3] = true;
   G[n-1][n-2] = G[n-2][n-1] = true;
   for (i = 0; i < n; i++)
      G[i][n-1] = G[n-1][i] = false;
   G[n-1][n-2] = G[n-2][n-1] = true;
   G[n-3][n-3] = G[n-2][n-2] = G[n-1][n-1] = false;
   CheckAdjacencyMatrix(G, 2);
   return (IsScorpion(G) == true); // sting = n-1; tail = n-2; body = n-3
}

bool TestCase3() { // copy test case 2 and change it
   // copy test case 2
   Graph G;
   int i, j, m;
   m = n-2;
   for (i = 0; i < m; i++) {
      for (j = 0; j < m; j++) {
         G[i][j] = (i == j) ? false : (
            i <  m / 2 && j <  m / 2 ||
            i >= m / 2 && j >= m / 2 ||
            i == m / 2 && j == i + 1 ||
            j == m / 2 && i == j + 1
         );
      }
   };
   for (i = 0; i < n - 1; i++)
      G[i][n-3] = G[n-3][i] = true;
   G[n-1][n-3] = G[n-3][n-1] = false;
   for (i = 0; i < n; i++)
      G[i][n-2] = G[n-2][i] = false;
   G[n-3][n-2] = G[n-2][n-3] = true;
   G[n-1][n-2] = G[n-2][n-1] = true;
   for (i = 0; i < n; i++)
      G[i][n-1] = G[n-1][i] = false;
   G[n-1][n-2] = G[n-2][n-1] = true;
   G[n-3][n-3] = G[n-2][n-2] = G[n-1][n-1] = false;
   // end of test case 2;

   // change (remove the body):
   G[n-5][n-3] = G[n-3][n-5] = false;
   CheckAdjacencyMatrix(G, 3);
   return (IsScorpion(G) == false); // no body
}

int TestAlgorithm() {
   if (!TestCase1())
      return 1;
   else if (!TestCase2())
      return 2;
   else if (!TestCase3())
      return 3;
   else
      return 0;
}

void main() {
   printf("\n");
   int k = TestAlgorithm();
   if (k == 0)
      printf("Correct algorithm.\n");
   else
      printf("Incorrect algorithm: test number %d failed.\n", k);
   printf("\n");
}