package net.asteasolutions.aos.sharedprefs;

import android.app.Activity;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.widget.TextView;

public class SharedPreferencesDemoActivity extends Activity {

	@Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        
        // Get the app's shared preferences
        SharedPreferences app_preferences = 
        	getPreferences(MODE_PRIVATE);
        
        // Get the value for the run counter
        int counter = app_preferences.getInt("counter", 0);
        
        // Update the TextView
        TextView text = (TextView) findViewById(R.id.text);
        text.setText("This app has been started " + counter + " times.");
        
        // Increment the counter
        SharedPreferences.Editor editor = app_preferences.edit();
        editor.putInt("counter", ++counter);
        editor.commit();
    }
}