#include <iostream>

using namespace std;



template <class T>
struct elem_cir
{
	T inf;
	elem_cir<T>* link;
};

template <class T>
class CirList
{
public:
	CirList();
	~CirList();
	CirList(CirList const &);
	CirList& operator=(CirList const &);
	void IterStart(elem_cir<T>* = NULL);
	elem_cir<T>* Iter();
	void Insert(T const &);
	void ToEnd(T const &);
	void DeleteElem(elem_cir<T> *, T &);
	void print();
private:
	elem_cir<T> *Start,
			    *Current;
	void DeleteList();
	void CopyList(CirList const &);
};

template <class T>
CirList<T>::CirList()
{
	Start = Current = NULL;
}

template <class T>
CirList<T>::~CirList()
{
	DeleteList();
}

template <class T>
CirList<T>::CirList(CirList const &r)
{
	CopyList(r);
}


template <class T>
CirList<T>& CirList<T>::operator=(CirList const &r)
{
	if (this != &r)
	{
		DeleteList();
		CopyList(r);
	}

	return *this;
}

template <class T>
void CirList<T>::IterStart(elem_cir<T> *p)
{
	if (p)
		Current = p;
	else
		if (Start)
			Current = Start->link;
		else
			Current = NULL;
}

template <class T>
elem_cir<T>* CirList<T>::Iter()
{
	if (!Current)
		return NULL;

	elem_cir<T> *p = Current;

	if (Current == Start)
		Current = NULL;
	else
		Current = Current->link;

	return p;
}

template <class T>
void CirList<T>::DeleteList()
{
	IterStart();
	elem_cir<T> *p = Iter();

	while (p)
	{
		delete p;
		p = Iter();
	}
}

template <class T>
void CirList<T>::CopyList(CirList<T> const &r)
{
	Start = NULL;
	elem_cir<T> *p = r.Start;
	if (p)
	{
		p = p->link;
		while (p != r.Start)
		{
			ToEnd(p->inf);
			p = p->link;
		}
		ToEnd(p->inf);
	}
}

template <class T>
void CirList<T>::Insert(T const &x)
{
	elem_cir<T> *p = new elem_cir<T>;
	p->inf = x;
	if (Start)
	{
		p->link = Start->link;
		Start->link = p;
	}
	else
	{
		Start = p;
		Start->link = p;
	}
}

template <class T>
void CirList<T>::ToEnd(T const &x)
{
	Insert(x);
	Start = Start->link;
}

template <class T>
void CirList<T>::DeleteElem(elem_cir<T> *p, T &x)
{
	x = p->inf;
	if (Start == Start->link)
	{
		Start = NULL;
		delete p;
	}
	else
	{
		elem_cir<T> *q = Start;
		while (q->link != p)
			q = q->link;
		q->link = p->link;
		if (p == Start)
			Start = q;
		delete p;
	}
}

template <class T>
void CirList<T>::print()
{
	IterStart();
	elem_cir<T> *p = Iter();

	while (p)
	{
		cout<< p->inf <<" ";
		p = Iter();
	}
	cout<<"\n";
}


template<typename T>
elem_cir<T> * FindMin(CirList<T> & list)
{
    elem_cir<T> * p = NULL, * temp;

    list.IterStart();
    p = list.Iter();
    temp = p;

    while(p=list.Iter())
    {

        if (temp->inf > p->inf)
            {
                temp = p;
            }

    }

    return temp;
}

template<typename T>
elem_cir<T> * FindMax(CirList<T> & list)
{
    elem_cir<T> * p = NULL, * temp;

    list.IterStart();
    p = list.Iter();
    temp = p;

    while(p=list.Iter())
    {

        if (temp->inf < p->inf)
            {
                temp = p;
            }

    }

    return temp;
}
// :)
template<typename T>
bool TestListMonotone2(CirList<T> & list)
{

    //IterStart()
    //Iter()

    elem_cir<T> * p = FindMax(list);
    elem_cir<T> * q = FindMin(list);

    //cout << p->inf << " " << q->inf << endl;

    for(elem_cir<T> * r = p; r != q; r=r->link)
    {
     //cout << r->inf << endl;
         if(r->link->inf > r->inf)
            return false;

    }
    for(elem_cir<T> * r =  q; r != p; r=r->link)
        if(r->link->inf < r->inf)
            return false;

    //list.IterStart();
    //while(p=list.Iter())
    //{
    //
    //}
    return true;
}


int main()
{

    CirList<int> list, list2;

    list.ToEnd(2);
    list.ToEnd(3);
    list.ToEnd(-4);
    list.ToEnd(5);
    list.ToEnd(4);
    list.ToEnd(1);

    cout << TestListMonotone2(list2) << endl;
    return 0;
}
