#include <iostream>

using namespace std;


template <class T>
struct elem_link2
{
	T inf;
	elem_link2<T> *pred,
				  *succ;
};

template <class T>
class DLList
{
public:
	DLList();
	~DLList();
	DLList(DLList const &);
	DLList& operator=(DLList const &);
	void IterStart(elem_link2<T>* = NULL);
	elem_link2<T>* IterSucc();
	void IterEnd(elem_link2<T>* = NULL);
	elem_link2<T>* IterPred();
	void ToEnd(T const &);
	void DeleteElem(elem_link2<T> *, T &);
	void print();
	void print_reverse();
	bool Empty() { return Start==NULL;}
private:
	elem_link2<T> *Start,
		          *End,
				  *CurrentS,
				  *CurrentE;
	void DeleteList();
	void CopyList(DLList const &);
};

template <class T>
DLList<T>::DLList()
{
	Start = End = NULL;
}

template <class T>
DLList<T>::~DLList()
{
	DeleteList();
}

template <class T>
DLList<T>::DLList(DLList<T> const &r)
{
	CopyList(r);
}

template <class T>
DLList<T>& DLList<T>::operator=(DLList<T> const &r)
{
	if (this != &r)
	{
		DeleteList();
		CopyList(r);
	}

	return *this;
}

template <class T>
void DLList<T>::DeleteList()
{
	elem_link2<T> *p = Start;
	while (p)
	{
		Start = Start->succ;
		delete p;
		p = Start;
	}
	End = NULL;
}

template <class T>
void DLList<T>::CopyList(DLList<T> const &r)
{
	Start = End = NULL;
	elem_link2<T> *p = r.Start;

	while (p)
	{
		ToEnd(p->inf);
		p = p->succ;
	}
}

template <class T>
void DLList<T>::ToEnd(T const &x)
{
	elem_link2<T> *p = new elem_link2<T>;
	p->inf = x;
	p->succ = NULL;
	p->pred = End;
	if (End)
	{
		End->succ = p;
		End = p;
	}
	else
	{
		Start = End = p;
	}
}


template <class T>
void DLList<T>::IterStart(elem_link2<T> *p)
{
	if (p)
		CurrentS = p;
	else
		CurrentS = Start;
}

template <class T>
elem_link2<T>* DLList<T>::IterSucc()
{
	elem_link2<T> *p = CurrentS;
	if (CurrentS)
		CurrentS = CurrentS->succ;
	return p;
}

template <class T>
void DLList<T>::IterEnd(elem_link2<T> *p)
{
	if (p)
		CurrentE = p;
	else
		CurrentE = End;
}

template <class T>
elem_link2<T>* DLList<T>::IterPred()
{
	elem_link2<T> *p = CurrentE;
	if (CurrentE)
		CurrentE = CurrentE->pred;
	return p;
}

template <class T>
void DLList<T>::DeleteElem(elem_link2<T> *p, T &x)
{
	x = p->inf;
	if (Start == End)
	{
		Start = NULL;
		End = NULL;
	}
	else
		if (p == Start)
		{
			Start = Start->succ;
			Start->pred = NULL;
		}
		else
			if (p == End)
			{
				End = End->pred;
				End->succ = NULL;
			}
			else
			{
				p->pred->succ = p->succ;
				p->succ->pred = p->pred;
			}
	delete p;
}

template <class T>
void DLList<T>::print()
{
	elem_link2<T> *p = Start;
	while (p)
	{
		cout<< p->inf <<" ";
		p = p->succ;
	}
	cout<<"\n";
}

template <class T>
void DLList<T>::print_reverse()
{
	elem_link2<T> *p = End;
	while (p)
	{
		cout<< p->inf <<" ";
		p = p->pred;
	}
	cout<<"\n";
}

// ;)




void ProcessList(DLList<int> & list)
{

    elem_link2<int> *p = NULL;
    list.IterStart();

    if(list.Empty())
        return;

    while(p=list.IterSucc())
    {
        elem_link2<int> * q = p->succ;

        if(q==NULL)
            break;

        int dummy;
        int sum = p->inf + q->inf;
        if(sum%2 != 0)
            list.DeleteElem(p, dummy);
        else
            p->inf = sum/2;

        if(list.Empty())
            return;

        list.IterStart(q);

    }

    if(list.Empty())
        return;

    list.IterEnd();
    int dummy;
    list.DeleteElem(list.IterPred(), dummy);

}

int main()
{
    DLList<int> list;

    list.ToEnd(5);
    list.ToEnd(3);
    list.ToEnd(2);
    list.ToEnd(6);
    list.ToEnd(8);
    list.ToEnd(2);
    list.ToEnd(1);


    // 4, 4, 7, 5

    ProcessList(list);

    list.print();

    return 0;
}
