package net.asteasolutions.aos;

import android.app.FragmentTransaction;
import android.app.ListFragment;
import android.appwidget.AppWidgetManager;
import android.os.Bundle;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.RemoteViews;

public class AuthorListFragment extends ListFragment {
    
    
    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        
        setListAdapter(new ArrayAdapter<String>(
                getActivity(), 
                R.layout.author_item, 
                R.id.author_name, 
                Quotes.getAuthors()));
        
        getListView().setChoiceMode(ListView.CHOICE_MODE_SINGLE);
    }
    
    @Override
    public void onListItemClick(ListView l, View v, int position, long id) {
        showQuotes(position);
        
        Persister.persist(getActivity(), position);
        
        RemoteViews views = new RemoteViews(getActivity().getPackageName(), R.layout.appwidget);
        views.setCharSequence(R.id.appwidget_quote, "setText", Persister.restore(getActivity()));

        // Tell the AppWidgetManager to perform an update on the current app widget
        AppWidgetManager instance = AppWidgetManager.getInstance(getActivity());
        
        instance.updateAppWidget(instance.getAppWidgetIds(instance.getInstalledProviders().get(0).provider), views);
        
    }
    
    void showQuotes(int index) {
        
        QuotesFragment quotes = new QuotesFragment(Quotes.getQuotes(index));
        
        FragmentTransaction transaction = getFragmentManager().beginTransaction();
        transaction.replace(R.id.quotes, quotes);
        transaction.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_FADE);
        transaction.commit();
    }
}
