package net.asteasolutions.aos;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;


public class Persister {
    public static final String PREFS_KEY = "net.asteasolutions.aos.selected_author";
    
    public static void persist(Context activity, int position) {
        SharedPreferences prefs = activity.getSharedPreferences("quotes", Context.MODE_PRIVATE);
        Editor editor = prefs.edit();
        editor.putInt(PREFS_KEY, position);
        editor.commit();
    }
    
    public static String restore(Context context) {
        SharedPreferences prefs = context.getSharedPreferences("quotes", Context.MODE_WORLD_READABLE);
        int index = prefs.getInt(PREFS_KEY, 0);
        return Quotes.getQuotes(index)[0];
    }
}
