//
//  SecondViewController.m
//  Places
//
//  Created by Dobrin Dobrev on 11/29/11.
//  Copyright (c) 2011 __MyCompanyName__. All rights reserved.
//

#import "SecondViewController.h"
#import "Place.h"
#import <QuartzCore/QuartzCore.h>

@implementation SecondViewController

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        self.title = NSLocalizedString(@"Second", @"Second");
        self.tabBarItem.image = [UIImage imageNamed:@"second"];
    }
    return self;
}
							
- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Release any cached data, images, etc that aren't in use.
}

#pragma mark - View lifecycle

- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view, typically from a nib.
}

- (void)viewDidUnload
{
    [super viewDidUnload];
    // Release any retained subviews of the main view.
    // e.g. self.myOutlet = nil;
}

- (void)viewDidAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
}

- (void)clearAllShadows {
    for (UIImageView *placeImage in placesImages) {
        placeImage.layer.shadowOffset = CGSizeZero;
        placeImage.layer.shadowOpacity = 0.0;
    }
}

- (void)imageTapped:(UITapGestureRecognizer*)tapGR {
    [self clearAllShadows];
    tapGR.view.layer.shadowColor = [[UIColor blackColor] CGColor];
    tapGR.view.layer.shadowOffset = CGSizeMake(10.0, 10.0);
    tapGR.view.layer.shadowOpacity = 0.8;
}

- (void)showDetailView:(UILongPressGestureRecognizer*)longPress {
    if (!detailViewController) {
        detailViewController = [[DetailViewController alloc] init];
    }
    Place *placePressed = [[[self.tabBarController.viewControllers objectAtIndex:0] places] objectAtIndex:longPress.view.tag];
    detailViewController.place = placePressed;
    [self.view addSubview:detailViewController.view];
}

- (void)imageDragged:(UIPanGestureRecognizer*)panGR {
    panGR.view.center = [panGR locationInView:panGR.view.superview];
}

- (UIImageView*)createImageView:(Place*)place index:(int)i {
    UIImageView *result = [[UIImageView alloc] init];
    
    UIGraphicsBeginImageContext(CGSizeMake(50.0, 50.0));
    CGContextRef context = UIGraphicsGetCurrentContext();
    
    UIImage *image;
    if (place.isCinema) {
        image = [UIImage imageNamed:@"cinema.gif"];
    } else {
        image = [UIImage imageNamed:@"restaurant.gif"];
    }
    UIImageView *imageView = [[UIImageView alloc] initWithImage:image];
    imageView.frame = CGRectMake(0.0, 0.0, 50.0, 50.0);
    [imageView.layer renderInContext:context];
    [imageView release];
    
    CGContextBeginPath(context);
    CGContextAddArc(context, 10.0, 10.0, 10.0, 0.0, M_PI*2, 1);
    if (place.liked) {
        CGContextSetRGBFillColor(context, 0.0, 1.0, 0.0, 0.5);
    } else {
        CGContextSetRGBFillColor(context, 1.0, 0.0, 0.0, 0.5);
    }
    
    CGContextFillPath(context);
    
    image = UIGraphicsGetImageFromCurrentImageContext();
    UIGraphicsEndImageContext();
    
    result.image = image;
    
    result.userInteractionEnabled = YES;
    
    UITapGestureRecognizer *tapGR = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(imageTapped:)];
    
    [tapGR requireGestureRecognizerToFail:doubleTapGR];
    
    [result addGestureRecognizer:tapGR];
    
    [tapGR release];
    
    UIPanGestureRecognizer  *panGR = [[UIPanGestureRecognizer alloc] initWithTarget:self action:@selector(imageDragged:)];
    [result addGestureRecognizer:panGR];
    [panGR release];
    
    UILongPressGestureRecognizer *longPressGR = [[UILongPressGestureRecognizer alloc] initWithTarget:self action:@selector(showDetailView:)];
    [result addGestureRecognizer:longPressGR];
    [longPressGR release];
    
    result.tag = i;
    
    return [result autorelease];
}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    
    if (!placesImages) {
        placesImages = [[NSMutableArray alloc] init];
    }
    if (!doubleTapGR) {
        doubleTapGR = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(clearAllShadows)];
        doubleTapGR.numberOfTapsRequired = 2;
        [self.view addGestureRecognizer:doubleTapGR];
    }

    int i=0;
    
    for (Place* place in [[self.tabBarController.viewControllers objectAtIndex:0] places]) {
        UIImageView *placeImage = [self createImageView:place index:i];
        i++;
        CGFloat x = rand() % 270;
        CGFloat y = rand() % 430;
        placeImage.frame = CGRectMake(x, y, 50.0, 50.0);
        [placesImages addObject:placeImage];
        [self.view addSubview:placeImage];
    }
    
}

- (void)viewWillDisappear:(BOOL)animated
{
	[super viewWillDisappear:animated];
    for (UIImageView* placeImage in placesImages) {
        [placeImage removeFromSuperview];
    }
    
    [placesImages removeAllObjects];
}

- (void)viewDidDisappear:(BOOL)animated
{
	[super viewDidDisappear:animated];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    // Return YES for supported orientations
    return (interfaceOrientation != UIInterfaceOrientationPortraitUpsideDown);
}

@end
