//
//  ServerCallViewController.m
//  ServerCall
//
//  Created by Pavlina Koleva on 1/4/12.
//  Copyright 2012 __MyCompanyName__. All rights reserved.
//

#import "ServerCallViewController.h"

@implementation ServerCallViewController
@synthesize receivedData;

- (void)dealloc
{
    [super dealloc];
}

- (void)didReceiveMemoryWarning
{
    // Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
    
    // Release any cached data, images, etc that aren't in use.
}

#pragma mark - View lifecycle


// Implement viewDidLoad to do additional setup after loading the view, typically from a nib.
- (void)viewDidLoad
{
    [super viewDidLoad];
    //create the request
    [self loadConnection];
        
}

- (void) loadConnection {
    NSURLRequest *theRequest = 
    [NSURLRequest requestWithURL:[NSURL URLWithString:@"http://localhost:8080/PrimeDetector/detect-prime-1?23"]
                     cachePolicy:NSURLRequestReloadIgnoringLocalCacheData
                 timeoutInterval:10.0];
    
    //create the connection
    //note that the delegate is self so the delegate methods must be defined in this class
    NSURLConnection *theConnection=[[NSURLConnection alloc] initWithRequest:theRequest delegate:self];
    
    if (theConnection) {
        //create the NSMutableData to hold the received data
        self.receivedData = [[NSMutableData data] retain];
    } else {
        //inform the user that the connection failed
        UIAlertView *connectionFailedMessage = [[UIAlertView alloc] initWithTitle:@"URLConnection"
                                                                          message:@"Connection to the server failed!" 
                                                                         delegate:self 
                                                                cancelButtonTitle:@"OK" 
                                                                otherButtonTitles:nil];
        [connectionFailedMessage show];
        [connectionFailedMessage release];
    }
}

- (void)connection:(NSURLConnection *)connection didReceiveData:(NSData *)data
{
    // Append the new data to receivedData.
    [receivedData appendData:data];
}

- (void)connection:(NSURLConnection *)connection didFailWithError:(NSError *)error
{
    // release the connection, and the data object
    // receivedData is declared as a method instance elsewhere
    
    [connection release];
    
    // inform the user
    UIAlertView *didFailWithErrorMessage = [[UIAlertView alloc] initWithTitle: @"NSURLConnection " message: @"didFailWithError"  delegate: self cancelButtonTitle: @"Ok" otherButtonTitles: nil];
    [didFailWithErrorMessage show];
    [didFailWithErrorMessage release];
	
    //inform the user
    NSLog(@"Connection failed! Error - %@",[error localizedDescription]);
}

- (void)connectionDidFinishLoading:(NSURLConnection *)connection
{
    // do something with the data
    // receivedData is declared as an instance variable elsewhere
    // in this example, convert data (from plist) to a string and then to a dictionary
    NSString *dataString = [[NSString alloc] initWithData: receivedData  encoding:NSUTF8StringEncoding];    
    //alert the user

    NSLog(@"String:\n%@",dataString);
    UIAlertView *finishedLoadingMessage = [[UIAlertView alloc] initWithTitle: @"NSURLConnection " message:@"Sending Succeded!"  delegate: self cancelButtonTitle: @"Ok" otherButtonTitles: nil];
    [finishedLoadingMessage show];
    [finishedLoadingMessage release];
    
    // release the connection, and the data object
    [connection release];
    [receivedData release];
}


- (void)viewDidUnload
{
    [super viewDidUnload];
    // Release any retained subviews of the main view.
    // e.g. self.myOutlet = nil;
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    // Return YES for supported orientations
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}

@end
