#include <cstdio>
#define maxN (1<<10)

int mas[maxN];
int n;

int partition(int x, int f, int l)
{
    while(f <= l) {
        while(mas[f] < x) ++f;
        while(mas[l] > x) --l;
        if(f <= l) {
            int tmp = mas[f];
            mas[f] = mas[l];
            mas[l] = tmp;
            ++f; --l;
        }
    }
    return l;
}

void myqsort(int f, int l)
{
    if(f >= l) return;
    int s = partition(mas[f], f, l);
    if(s < f) s = f;

    myqsort(f, s);
    myqsort(s + 1, l);
}

int main()
{
    scanf("%d", &n);
    for(int i = 0; i < n; i++)
        scanf("%d", &mas[i]);
    myqsort(0, n - 1);
    printf("%d", mas[0]);
    for(int i = 1; i < n; i++)
        printf(" %d", mas[i]);
    printf("\n");
    return 0;
}
