#pragma once

class String
{
public:
	String(const String &);
	String(const char * = "");
	~String();

	unsigned getLength() const;
	unsigned getCapacity() const;

	//    .   s.toUpper().append(String("other string"));
	String& toUpper();
	String& toLower();

	String& append(const char);
	String& append(const String &);

	String& remove(const char);
	String& removeAll(const String&);

	//    .
	char getAt(unsigned) const;
	void setAt(unsigned, const char);

	void print() const;

private:
	//     
	void init(const char *);

	//    .
	String& operator=(const String &);

	char * real; //  
	unsigned capacity; //    
	unsigned length; //   
};
