#include "String.h"
#include <cstring>
#include <iostream>

using namespace std; //     

void printHelper(const char * str)
{
	cout << str << endl;
}

String::String(const char * cstr)
{
	printHelper("C string ctor");
	init(cstr);
}

String::~String()
{
	printHelper("Destructor");
}

String::String(const String & other)
{
	printHelper("Copy ctor");
	init(other.real);
}

void String::init(const char * cstr)
{
	capacity = strlen(cstr);
	length = capacity;
	real = new char[capacity+1];
	strcpy(real, cstr);
}

void String::print()const
{
	cout << real << endl;
}

String& String::toLower()
{
	for ( unsigned i = 0; i < length; ++ i)
	{
		if ( real[i] <= 'Z' && real[i] >= 'A' )
		{
			real[i] = real[i] - 'A' + 'a';
		}
	}

	return *this;
}

String& String::remove(const char c)
{
	unsigned writePos = 0;
	unsigned readPos = 0;

	unsigned missedPositions = 0;

	for (; readPos < length; ++readPos )
	{
		if ( real[readPos] == c )
		{
			++missedPositions;
		}
		else
		{
			real[writePos] = real[readPos];
			++writePos;
		}
	}

	length -= missedPositions;
	// missedPositions == readPositions - writePos

	return *this;
}