#include <iostream>
#include <queue>

template<typename T>
class Queue
{
private:

	template<typename T>
	struct Node
	{
		T data;
		Node* next;
		Node(T _data) : data(_data), next(nullptr) {};
	};

	Node<T>* front;
	Node<T>* rear;
	int size;

public:
	Queue()
	{
		front = rear = nullptr;
		size = 0;
	}
	~Queue()
	{
		while (front)
		{
			Node<T>* toDel = front;
			front = front->next;
			delete toDel;
		}
	}
	void enqueue(const T el)
	{
		if (!front)
		{
			front = rear = new Node<T>(el);
		}
		else
		{
			Node<T>* newEl = new Node<T>(el);
			if (newEl != nullptr)
			{
				rear->next = newEl;
				rear = newEl;
			}
		}
		size++;
	}
	bool isEmpty() const
	{
		return front == nullptr;
	}
	void dequeue()
	{
		if (isEmpty())
		{
			std::cout << "The queue is empty" << std::endl;
			return;
		}
		else
		{
			Node<T>* elToDel = front;
			front = front->next;
			delete elToDel;
		}
		size--;
	}
	T& first()
	{
		if (isEmpty())
		{
			std::cerr << "Stack is empty\n";
		}
		else
		{
			return front->data;
		}
	}

	int sizeOfQueue() const
	{
		return size;
	}

	void print() const
	{
		while (!isEmpty())
		{
			std::cout << front->data << "  ";
			dequeue();
		}
	}

};

int funct(int n, int k)
{
	std::queue<int> queue;
	for (int i = 1; i <= n; i++)
	{
		queue.push(i);
	}
	while (queue.size() > 1)
	{
		for (size_t i = 1; i < k; i++)
		{
			queue.push(queue.front());
			queue.pop();
		}
		queue.pop();
	}
	return queue.front();
}

int main()
{
	Queue<int> q;
	std::queue<int> queue;

	int n = 10;
	int k = 2;

	std::cout << funct(n, k);
	
	//int t = q.first();
	return 0;
}