#include "Trees.h"

void Tree::clear(TreeNode * root)
{
	if (!root)
	{
		return;
	}
	else
	{
		for (int i = 0; i < root->children.size(); i++)
		{
			clear(root->children[i]);
		}
		delete root;
	}
}

TreeNode * Tree::copy(TreeNode * root)
{
	if (!root)
	{
		return nullptr;
	}
	else
	{
		TreeNode* node = new TreeNode(root->data);
		for (size_t i = 0; i < root->children.size(); i++)
		{
			node->children.push_back(copy(root->children[i]));
		}
		return node;
	}
}

Tree::Tree()
{
	root = nullptr;
}

Tree::Tree(const Tree & other)
{
	root = copy(other.root);
}

Tree::~Tree()
{
	clear(root);
}

void Tree2::clear(TreeNode2 * root)
{
	if (!root)
	{
		return;
	}
	else
	{
		clear(root->child);
		clear(root->sibling);
		delete root;
	}
}

TreeNode2 * Tree2::copy(TreeNode2 * root)
{
	if (!root)
	{
		return nullptr;
	}
	else
	{
		TreeNode2* node = new TreeNode2(root->data);
		node->child = copy(root->child);
		node->sibling = copy(root->sibling);
		return node;
	}

}

Tree2::Tree2()
{
	root = nullptr;
}

Tree2::Tree2(const Tree2 & other)
{
	root = copy(other.root);
}

Tree2::~Tree2()
{
	clear(root);
}
