#include "Tree.h"

void Tree::clear(TreeNode * root)
{
	if (!root)
	{
		return;
	}
	else
	{
		for (int i = 0; i < root->children.size(); i++)
		{
			clear(root->children[i]);
		}
		delete root;
	}
}

TreeNode * Tree::copy(TreeNode * root)
{
	if (!root)
	{
		return nullptr;
	}
	else
	{
		TreeNode* node = new TreeNode(root->data);
		for (size_t i = 0; i < root->children.size(); i++)
		{
			node->children.push_back(copy(root->children[i]));
		}
		return node;
	}
}

void Tree::insert(TreeNode *& root, int * path, int level, int el)
{
	if (!root && level != 0)
	{
		return;
	}
	if (!root && level == 0)
	{
		root = new TreeNode(el);
		return;
	}
	if (level == 1)
	{
		root->children.push_back(new TreeNode(el));
	}
	else
	{
		for (int i = 0; i < root->children.size(); i++)
		{
			if (root->children[i]->data == *path)
			{
				insert(root->children[i], path + 1, level - 1, el);
			}
		}
	}
}

void Tree::howManySums(TreeNode *& root, int & count)
{
	if (!root)
	{
		return;
	}
	else
	{
		int sum = 0;
		for (size_t i = 0; i < root->children.size(); i++)
		{
			sum += root->children[i]->data;
		}
		if (sum == root->data)
		{
			count++;
		}
		for (size_t i = 0; i < root->children.size(); i++)
		{
			howManySums(root->children[i], count);
		}
	}
}

bool Tree::isOnlyLarger(TreeNode * r)
{
	if (!r)
	{
		return true;
	}
	if (r->children.size() == 0)
	{
		return true;
	}
	bool flag = true;
	for (size_t i = 0; i < r->children.size(); i++)
	{
		flag = r->data > r->children[i]->data && isOnlyLarger(r->children[i]);
		if (!flag)
		{
			return false;
		}
	}
}

Tree::Tree()
{
	root = nullptr;
}

Tree::Tree(const Tree & other)
{
	root = copy(other.root);
}

Tree::~Tree()
{
	clear(root);
}

void Tree::insert(int * path, int level, int el)
{
	insert(root, path, level, el);
}

int Tree::howManySums()
{
	int count = 0;
	howManySums(root, count);
	return count;
}

bool Tree::isOnlyLarger()
{
	return isOnlyLarger(root);
}


void Tree2::clear(TreeNode2 * root)
{
	if (!root)
	{
		return;
	}
	else
	{
		clear(root->child);
		clear(root->sibling);
		delete root;
	}
}

TreeNode2 * Tree2::copy(TreeNode2 * root)
{
	if (!root)
	{
		return nullptr;
	}
	else
	{
		TreeNode2* node = new TreeNode2(root->data);
		node->child = copy(root->child);
		node->sibling = copy(root->sibling);
		return node;
	}

}

Tree2::Tree2()
{
	root = nullptr;
}

Tree2::Tree2(const Tree2 & other)
{
	root = copy(other.root);
}

Tree2::~Tree2()
{
	clear(root);
}
