#include "BinTree.h"

void BinTree::clear(Node * r)
{
	if (r)
	{
		clear(r->left);
		clear(r->right);
		delete r;
	}
}

Node * BinTree::copy(Node * r) 
{
	if (!r)
	{
		return nullptr;
	}
	return new Node(r->data, copy(r->left), copy(r->right));
}

void BinTree::print(Node * r) const
{
	if (r)
	{
		print(r->left);
		std::cout << r->data << " ";
		print(r->right);
	}
}

void BinTree::insert(Node *& r, std::string key, const char * path)
{
	if (!r)
	{
		r = new Node(key);
		return;
	}
	if (path[0] == 'L')
	{
		insert(r->left, key, path + 1);
	}
	else
	{
		insert(r->right, key, path + 1);
	}
}

bool BinTree::areSiblings(Node * r, std::string & one, std::string & two) const
{
	if (r == nullptr) return false;
	if (r->left != nullptr && r->right != nullptr && ((r->left->data == one && r->right->data == two) || (r->left->data == two && r->right->data == one)))
	{
		return true;
	}
	return areSiblings(r->left, one, two) || areSiblings(r->right, one, two);
}

int BinTree::getLevel(Node * r, std::string & str, int level) const
{
	if (r == nullptr)
	{
		return -1;
	}
	if (r->data == str)
	{
		return level;
	}
	int downLevel = getLevel(r->left, str, level + 1);
	if (downLevel != -1)
	{
		return downLevel;
	}
	downLevel = getLevel(r->right, str, level + 1);

	return downLevel;
}

bool BinTree::areCousins(Node * r, std::string & one, std::string & two) const
{
	if (!r || !r->left || !r->right) return false;
	if (getLevel(root, one, 0) == -1 || getLevel(root, two, 0) == -1)
	{
		return false;
	}
	if (getLevel(root, one, 0) == getLevel(root, two, 0) && !areSiblings(root, one, two)) return true;
	return false;

	//return ((getLevel(one) == getLevel(two)) && !areSiblings(one, two));
}

BinTree::BinTree()
{
	root = nullptr;
}

BinTree::~BinTree()
{
	clear(root);
}

BinTree::BinTree(const BinTree & other)
{
	root = copy(other.root);
}

void BinTree::print() const
{
	print(root);
}

void BinTree::insert(std::string key, const char * path)
{
	insert(root, key, path);
}

bool BinTree::areSiblings(std::string & one, std::string & two) const
{
	return areSiblings(root, one, two);
}

int BinTree::getLevel(std::string & str) const
{
	return getLevel(root, str, 0);
}

bool BinTree::areCousins(std::string & one, std::string & two) const
{
	return areCousins(root, one, two);
}
