#pragma once
#include <string>
#include <iostream>

struct Node {
	std::string data;
	Node* left;
	Node* right;
	Node(std::string _data, Node* _left = nullptr, Node* _right = nullptr) : data(_data), left(_left), right(_right) {};
};

class BinTree
{
private:
	Node* root;
	void clear(Node* r);
	Node* copy(Node* r);
	void print(Node* r) const;
	void insert(Node*& r, std::string key, const char* path);
	bool areSiblings(Node*r, std::string& one, std::string& two) const;
	int getLevel(Node* r, std::string& str, int level)const ;
	bool areCousins(Node*r, std::string& one, std::string& two) const;

public:
	BinTree();
	~BinTree();
	BinTree(const BinTree& other);
	void print() const;
	void insert(std::string key, const char* path);
	bool areSiblings(std::string& one, std::string& two) const;
	int getLevel(std::string& str) const;
	bool areCousins(std::string& one, std::string& two) const;
};