#include "List.h"

DoubleLinkedList::DoubleLinkedList()
{
	pHead = nullptr;
	pTail = nullptr;
}

DoubleLinkedList::~DoubleLinkedList()
{
	destroy();
}

void DoubleLinkedList::destroy()
{
	while (pHead)
	{
		DListNode* temp = pHead;
		pHead = temp->next;
		delete temp;
	}
}

void DoubleLinkedList::print() const
{
	DListNode* curr = pHead;
	while (curr)
	{
		std::cout << curr->data;
		if (curr->next)
		{
			std::cout << " -> ";
		}
		curr = curr->next;
	}
}

void DoubleLinkedList::addEnd(int el)
{
	if (!pTail)
	{
		pHead = pTail = new DListNode(el);
	}
	else
	{
		DListNode* newEl = new DListNode(el);
		pTail->next = newEl;
		newEl->prev = pTail;
		pTail = newEl;
	}
}

void DoubleLinkedList::removeAt(DListNode *& curr)
{
	DListNode* next = curr->next;
	if (curr->prev)
	{
		curr->prev->next = curr->next;
	}
	if (curr->next)
	{
		curr->next->prev = curr->prev;
	}
	delete curr;
	curr = next;
}

void DoubleLinkedList::oddFirst()
{
	if (!pHead)
	{
		return;
	}
	DListNode* curr = pHead;
	DListNode* last = pTail;
	bool allEven = true;
	while (curr && curr != last && allEven)
	{
		if (curr->data % 2 == 0)
		{
			addEnd(curr->data);
			removeAt(curr);
		}
		else
		{
			allEven = false;
			pHead = curr;
		}
	}
	if (allEven)
	{
		pHead = last;
	}
	else
	{
		while (curr && curr != last)
		{
			if (curr->data % 2 == 0)
			{
				addEnd(curr->data);
				removeAt(curr);
			}
			else
			{
				curr = curr->next;
			}
		}
	}

}
