#include "BinTree.h"

void BinTree::clear(Node * r)
{
	if (r)
	{
		clear(r->left);
		clear(r->right);
		delete r;
	}
}

Node * BinTree::copy(Node * r)
{
	if (!r)
	{
		return nullptr;
	}
	return new Node(r->data, copy(r->left), copy(r->right));
}

void BinTree::print(Node * r) const
{
	if (r)
	{
		print(r->left);
		std::cout << r->data << " ";
		print(r->right);
	}

}

void BinTree::insert(Node *& r, int key, const char * path)
{
	if (!r)
	{
		r = new Node(key);
		return;
	}
	if (path[0] == 'L')
	{
		insert(r->left, key, path + 1);
	}
	else
	{
		insert(r->right, key, path + 1);
	}
}

void BinTree::sumOfParentWithXChild(Node * r, int & sum, int x)
{
	if (!r)
	{
		return;
	}
	if ((r->left && r->left->data == x) || (r->right && r->right->data == x))
	{
		sum += r->data;
	}

	sumOfParentWithXChild(r->left, sum, x);
	sumOfParentWithXChild(r->right, sum, x);
}

void BinTree::insert(Node *& r, int x)
{
	if (!r)
	{
		r = new Node(x);
	}
	else
	{
		if (r->data < x)
		{
			insert(r->right, x);
		}
		else
		{
			insert(r->left, x);
		}
	}
}

void BinTree::sumOfBOundaries(Node * r, int& sum, int x, int y)
{
	if (!r)
	{
		return;
	}
	if (r->data <= y && r->data >= x)
	{
		sum += r->data;
	}
	
	if (r->data < x)
	{
		sumOfBOundaries(r->right, sum, x, y);
	}
	else if (r->data > y)
	{
		sumOfBOundaries(r->left, sum, x, y);
	}
	else
	{
		sumOfBOundaries(r->left, sum, x, y);
		sumOfBOundaries(r->right, sum, x, y);
	}
}

BinTree::BinTree()
{
	root = nullptr;
}

BinTree::~BinTree()
{
	clear(root);
}

BinTree::BinTree(const BinTree & other)
{
	root = copy(other.root);
}

void BinTree::print() const
{
	//print(root);
	std::queue<Node*> q;
	if (!root)
	{
		return;
	}
	q.push(root);
	while (!q.empty())
	{
		Node* curr = q.front();
		q.pop();
		std::cout << curr->data << "  ";
		if(curr->left)
		q.push(curr->left);
		if(curr->right)
		q.push(curr->right);
	}

}

void BinTree::insert(int key, const char * path)
{
	insert(root, key, path);
}

void BinTree::insert(int el)
{
	insert(root, el);
}

int BinTree::sumOfParentWithXChild(int x)
{
	int sum = 0;

	sumOfParentWithXChild(root, sum, x);

	return sum;
}

int BinTree::sumOfBoundaries(int x, int y)
{
	int sum = 0;

	sumOfBOundaries(root, sum, x, y);

	return sum;
}
