#pragma once
#include <iostream>

struct ListNode {
	char data;
	ListNode* next;
	ListNode(char _data, ListNode* _next = nullptr) : data(_data) { next = _next; }
};

class List {
private:
	ListNode* first;
	ListNode* last;
	int length;
	char node;
	void copy(const List& other);
public:
	List();
	List(char);
	~List();
	List(const List& other);
	List& operator=(const List& other);
	void destroy();
	void print() const;
	void addEnd(char);
	bool search(char) const;
	char getNode() const;
	char get(int possition) const;
	int getLength() const;
};