#include "GLinkedList.h"


void List::copy(const List & other)
{
	if (!other.first)
	{
		return;
	}
	first = new ListNode(other.first->data);
	last = first;
	ListNode* cur = other.first->next;
	while (cur)
	{
		addEnd(cur->data);
		cur = cur->next;
	}
}

List::List()
{
	first = nullptr;
	last = nullptr;
	length = 0;
	node = ' ';
}

List::List(char _node)
{
	first = nullptr;
	last = nullptr;
	node = _node;
	length = 0;
}

List::~List()
{
	destroy();
}

List::List(const List & other)
{
	copy(other);
}

List & List::operator=(const List & other)
{
	if (this != &other)
	{
		destroy();
		copy(other);
	}
	return *this;
}

void List::destroy()
{
	while (first)
	{
		ListNode* temp = first;
		first = temp->next;
		delete temp;
	}
}

void List::print() const
{
	ListNode* curr = first;
	std::cout << node << ": ";
	while (curr)
	{
		std::cout << curr->data;
		if (curr->next)
		{
			std::cout << " -> ";
		}
		curr = curr->next;
	}
}

void List::addEnd(char el)
{
	if (!last)
	{
		first = last = new ListNode(el);
	}
	else
	{
		ListNode* newEl = new ListNode(el);
		last->next = newEl;
		last = newEl;
	}
	length++;
}

bool List::search(char el) const
{
	ListNode* current = first;
	while (current)
	{
		if (current->data == el)
		{
			return true;
		}
		else
		{
			current = current->next;
		}
	}
	return false;
}

char List::getNode() const
{
	return node;
}

char List::get(int possition) const
{
	if (possition > length)
	{
		throw new _exception;
	}
	ListNode* cur = first;
	int counter = 1;
	while (counter != length)
	{
		cur = cur->next;
		counter++;
	}
	return cur->data;
}

int List::getLength() const
{
	return length;
}
