#include "Graph.h"

void Graph::addNode(char _node, char connectedNode)
{
	if (_node == connectedNode)
	{
		return;
	}

	bool found = false;
	bool foundConnected = false;
	for (size_t i = 0; i < nodes.size(); i++)
	{
		if (nodes[i]->getNode() == _node)
		{
			found = true;
			if (!nodes[i]->search(connectedNode))
			{
				nodes[i]->addEnd(connectedNode);
			}
		}
		if (nodes[i]->getNode() == connectedNode)
		{
			foundConnected = true;
			if (!nodes[i]->search(_node))
			{
				nodes[i]->addEnd(_node);
			}
		}
	}

	if (!found)
	{
		List* newList = new List(_node);
		newList->addEnd(connectedNode);
		nodes.push_back(newList);
	}
	if (!foundConnected)
	{
		List* newList = new List(connectedNode);
		newList->addEnd(_node);
		nodes.push_back(newList);
	}
}


//   .     
bool Graph::isPath(char start, char end)
{
	bool found = false;
	int i = 0;
	for (; i < nodes.size(); i++)
	{
		if (nodes[i]->getNode() == start)
		{
			found = true;
			break;
		}
	}
	if (!found)
	{
		return false;
	}
	std::vector<char> visited;
	std::queue<ListNode*> q;
	while (!q.empty())
	{
		char cur = q.front()->data;
		if (cur == end)
		{
			return true;
		}
		visited.push_back(cur);
		
	}

}

void Graph::print() const
{
	for (size_t i = 0; i < nodes.size(); i++)
	{
		nodes[i]->print();
		std::cout << std::endl;
	}
}
