#include "Graph.h"

void Graph::addNode(char _node, char connectedNode)
{
	if (_node == connectedNode)
	{
		return;
	}

	bool found = false;
	bool foundConnected = false;
	for (size_t i = 0; i < nodes.size(); i++)
	{
		if (nodes[i]->getNode() == _node)
		{
			found = true;
			if (!nodes[i]->search(connectedNode))
			{
				nodes[i]->addEnd(connectedNode);
			}
		}
		if (nodes[i]->getNode() == connectedNode)
		{
			foundConnected = true;
			if (!nodes[i]->search(_node))
			{
				nodes[i]->addEnd(_node);
			}
		}
	}

	if (!found)
	{
		List* newList = new List(_node);
		newList->addEnd(connectedNode);
		nodes.push_back(newList);
	}
	if (!foundConnected)
	{
		List* newList = new List(connectedNode);
		newList->addEnd(_node);
		nodes.push_back(newList);
	}
}


//   .     
bool Graph::isPath(char start, char end)
{
	bool found = false;
	int i = 0;
	for (; i < nodes.size(); i++)
	{
		if (nodes[i]->getNode() == start)
		{
			found = true;
			break;
		}
	}
	if (!found)
	{
		return false;
	}
	std::vector<char> visited;
	std::queue<List*> q;

	q.push(nodes[i]);

	while (!q.empty())
	{
		List* cur = q.front();
		q.pop();
		if (cur->getNode() == end)
		{
			return true;
		}
		for (size_t j = 0; j < cur->getLength(); j++)
		{
			if (std::find(visited.begin(), visited.end(), cur->get(j)) != visited.end())
			{
				continue;
			}
			for (size_t k = 0; k < nodes.size(); k++)
			{
				if (nodes[k]->getNode() == cur->get(j))
				{
					q.push(nodes[k]);
					if (std::find(visited.begin(), visited.end(), cur->get(j)) == visited.end())
					{
						visited.push_back(cur->get(j));
					}
					break;
				}
			}
			
		}
		visited.push_back(cur->getNode());
	}

	return false;
}

void Graph::print() const
{
	for (size_t i = 0; i < nodes.size(); i++)
	{
		nodes[i]->print();
		std::cout << std::endl;
	}
}
