#pragma once
#include <iostream>
#include <queue>

struct Node {
	int data;
	Node* left;
	Node* right;
	Node(int _data, Node* _left = nullptr, Node* _right = nullptr) : data(_data), left(_left), right(_right) {};
};

class BinTree
{
private:
	Node* root;
	void clear(Node* r);
	Node* copy(Node* r);
	void print(Node* r) const;
	void insert(Node*& r, int key, const char* path);
	void sumOfParentWithXChild(Node* r, int& sum, int x);
	void insert(Node*& r, int x);
	void sumOfBOundaries(Node* r, int& sum,  int x, int y);
	void remove(Node*& r, int key);
	void finMinDiff(Node* r, int key, int& curr, int& MinDiffNode);
	int distanceBetween2(Node* r, int a, int b);
	int distanceFromSubRoot(Node* r, int x);
public:
	BinTree();
	~BinTree();
	BinTree(const BinTree& other);
	void print() const;
	void insert(int, const char* path);
	void insert(int el);
	int sumOfParentWithXChild(int x);
	int sumOfBoundaries(int x, int y);
	void remove(int key);
	int findMinDiff(int key);
	int findDistance(int a, int b);
};
