#include <iostream>
#include <math.h>
using namespace std;

/**
 * Returns the discriminant for a quadratic equation with the given parameters.
 */
double calculateDiscr(int a, int b, int c) {
	// Calculate the result.
	double discr = b * b - 4 * a * c;

	// Return the result to the calling function (main).
	return discr;
}

int main () {
	// Declare the variables representing the coefficients of the equation.
	int a, b ,c;

	// Prompt the user to input the coefficients.
	cout << "Enter the parameters for the quadratic equation: ";

	// Initialize the coefficients with the user input.
	cin >> a >> b >> c;

	// Passing the coefficients to a function that is doing the actual calculation.
	// The result returned by the function is assigned to the variable 'discr'.
	double discr = calculateDiscr(a, b, c);

	// If the discriminant is negative print a message.
	if (discr < 0) {
		cout << "No roots for the equation";
	}
	// Otherwise calculate the roots of the equation.
	else {
		double x1, x2;
		// sqrt is defined in the standard library math.h.
		// It accepts only arguments of type double and float.
		// Ergo passing an int will result in a compilation error.
		discr = sqrt(discr);
		x1 = (-b - discr) / (2 * a);
		x2 = (-b + discr) / (2 * a);
		// Print the roots on the screen.
		cout << "Roots for the equation are: " << x1 << " and " << x2 << "\n";
	}

	return 0;
}
