#include <iostream>
#include <cmath>
using namespace std;

#define PI 3.14

/**
 * Given two points returns the distance between them.
 * @param x1
 * 			The x-coordinates of the first point.
 * @param y1
 * 			The y-coordinates of the first point.
 * @param x2
 * 			The x-coordinates of the second point.
 * @param y2
 * 			The y-coordinates of the second point.
 */
double getSide(int x1, int y1, int x2, int y2) {
	double side = sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
	return side;
}

/**
 * Given three sides returns the area of the triangle using Heron's formula.
 * @param a
 * 			The first side of the triangle.
 * @param b
 * 			The second side of the triangle.
 * @param c
 * 			The third side of the triangle.
 */
double getArea(double a, double b, double c) {
	double p = (a + b + c) / 2;
	double s = sqrt(p * (p - a) * (p - b) * (p - c));
	return s;
}

/**
 * Calculate the area of heart - it is constructed of a triangle
 * with two semi-circles attached next to each other on the side
 * between the first and second points.
 *		  _  _
 *(x1,y1)/_\/_\(x2,y2)
 *	     \    /
 *	      \  /
 *	       \/(x3,y3)
 */
int main() {
	int x1, y1, x2, y2, x3, y3;
	cout << "Enter x1: "; cin >> x1;
	cout << "Enter y1: "; cin >> y1;
	cout << "Enter x2: "; cin >> x2;
	cout << "Enter y2: "; cin >> y2;
	cout << "Enter x3: "; cin >> x3;
	cout << "Enter y3: "; cin >> y3;

	double a = getSide(x1, y1, x2, y2),
		   b = getSide(x2, y2, x3, y3),
		   c = getSide(x3, y3, x1, y1);

	double triangleArea = getArea(a, b, c),
		   circleArea = PI * (a / 4) * (a / 4),
		   totalArea = triangleArea + circleArea;

	cout << totalArea;

	return 0;
}
