#include <iostream>
#include <iomanip>
using namespace std;

/**
 * A simple calculator that performs the basic binary
 * operations (sum, difference, product and division) on two integers.
 */
int main() {
	/**
	 * Using the setw() input/output manipulator function
	 * we set the number of characters to be displayed when
	 * printing the calculator string instead of
	 * manually adding the preceding white-spaces
	 */
	cout << "####################\n";
	cout << setw(15) << "calculator\n";
	cout << "####################\n";

	char op;
	cout << "Enter operation(+, -, *, /): "; cin >> op;

	int a, b, result;
	cout << "Enter two integers: "; cin >> a >> b;

	/**
	 * Switching a char is just like switching an int -
	 * after all characters are integers.
	 * We are checking the user input against
	 * the supported operations and perform them in the result
	 * variable which is displayed afterwards.
	 */
	switch (op) {
	case '+':
		result = a + b;
		break;
	case '-':
		result = a - b;
		break;
	case '*':
		result = a * b;
		break;
	case '/':
		result = a / b;
		break;
	default:
		/**
		 * If the user entered an operation that our calculator does not support
		 * we print a message and exit the program.
		 * Notice that the return value here is 1 instead of the usual zero.
		 * This is because 0 is used to indicate that the program finished normally.
		 * Returning 1 indicates that our program did not finish in its standard way.
		 */
		cout << "Invalid operation";
		return 1;
	}

	cout << "Result of operation is " << result;

	return 0;
}
