#include <iostream>
using namespace std;

/**
 * Check if a user-provided date is valid.
 */
int main() {
	int year, month, day;
	cout << "Enter year: "; cin >> year;
	cout << "Enter month: "; cin >> month;
	cout << "Enter day: "; cin >> day;
	/**
	 * For the date to be valid the year has to be positive and
	 * the month must be between 1 and 12.
	 */
	bool isValid = year >= 0 && month >= 1 && month <= 12;

	/**
	 * In addition to the initial conditions the date has to have the
	 * proper amount of days according to the month.
	 * That is what
	 * isValid = isValid && [condition for amount of days]
	 * is used for. If it was only
	 * isValid = [condition for amount of days]
	 * we would ignore the previous state of the variable -
	 * i.e. entering 1900 13 22 would return a valid date.
	 */
	switch (month) {
	case 4:
	case 6:
	case 9:
	case 11:
		isValid = isValid && day >= 1 && day <= 30;
		break;
	case 2:
		/**
		 * I know that this is not entirely correct.
		 */
		if (!(year % 4)) {
			isValid = isValid && day >= 1 && day <= 29;
		} else {
			isValid = isValid && day >= 1 && day <= 28;
		}
		break;
	default:
		isValid = isValid && day >= 1 && day <= 31;
		break;
	}
	if (isValid) {
		cout << "The date is valid\n";
	} else {
		cout << "The date is not valid\n";
	}
	return 0;
}
