function getRandomInt(max) {
  return Math.floor(Math.random() * max);
}

function imgMouseOver(event) {
	event.target.style.color = 'DarkRed';
}


function imgMouseOut(event) {
	event.target.style.color = 'black';
}


function imgClick(event) {
	const colors = ['blue', 'green', 'red', 'yellow', 'grey', 'white'];
	const target = event.currentTarget;

	target.style.backgroundColor = colors[getRandomInt(colors.length)];
}


function createImageNode(data) {
	let node = document.createElement("div");
	node.className = "image-div";
	
	let img = document.createElement("img");
	img.className = "picture";
	img.alt = data.alt;
	img.src = data.source;
	node.appendChild(img);
	
	let par = document.createElement("p");
	par.className = "description";
	par.textContent = data.description;
	node.appendChild(par);

/*
	node.innerHTML = `
		<img src="${data.source}" alt="${data.alt}" class="picture">
		<p class="description">${data.description}</p>
`
*/

	node.addEventListener('mouseover', imgMouseOver)
	node.addEventListener('mouseout', imgMouseOut)
	node.addEventListener('click', imgClick)
	return node;
}

function createGallery(root, data) {
	for (let i = 0; i < data.length; ++i) {
		root.appendChild(createImageNode(data[i]));
	}
}


function hideLoader () {
	const loaderNode = document.getElementById('loader');
	loaderNode.parentElement.removeChild(loaderNode);
}

function loadImages() {
	hideLoader();
	
	const galeryNode = document.getElementById('main-gallery-grid');
	const imageData = loadImageArray()
	createGallery(galeryNode, imageData);
}
