const TEXT_NODE = 3;

function printText(node) {
	if (node) {
		if (node.nodeType === TEXT_NODE) {
			console.log(node.textContent);
		}

		const children = node.childNodes;
		for (let i = 0; i < children.length; ++i) {
			printText(children[i]);
		}
	}
}

function countByClass(node, className) {
	let count = 0;
	if (node) {
		if (node.className === className) {
			count += 1;
		}

		const children = node.childNodes;
		for (let i = 0; i < children.length; ++i) {
			count += countByClass(children[i], className);
		}
	}
	return count;
}

function findElementByID(node, id) {
	if (node) {
		if (node.id === id) {
			return node;
		}

		const children = node.childNodes;
		for (let i = 0; i < children.length; ++i) {
			let result = findElementByID(children[i], id);
			if (result) {
				return result;
			}
		}
	}
	return null;
}

//checks if all ID-s are unique
function isCorrect(node, allIds) {
	var allIds = allIds || {};

	if (node) {
		if (node.id) {
			if (allIds[node.id]) {
				return false;
			}
			allIds[node.id] = true;
		}
		
		const children = node.childNodes;
		for (let i = 0; i < children.length; ++i) {
			let result = isCorrect(children[i], allIds);
			if (!result) {
				return false;
			}
		}
	}
	return true;
}

function colorizeText(node, text, color) {
	if (!node) return;	
	const children = node.childNodes;
	
	for (let i = 0; i < children.length; ++i) {
		const currentNode = children[i];
		if (currentNode && currentNode.nodeType === TEXT_NODE) {
			const textPosition = currentNode.textContent.indexOf(text);
			if (textPosition < 0) {
				continue;
			}
			
			const firstPart = children[i].textContent.substring(0, textPosition);
			const secondPart = children[i].textContent.substring(textPosition + text.length);

			const newNode = document.createElement("span");
			newNode.style.color = color;
			newNode.textContent = text;

			const replaceNode = document.createElement("div");
			replaceNode.appendChild(document.createTextNode(firstPart));
			replaceNode.appendChild(newNode);
			replaceNode.appendChild(document.createTextNode(secondPart));

			node.replaceChild(replaceNode, currentNode);
		}
		else {
			colorizeText(children[i], text, color);
		}
	}
}

//printText(document.body);
//console.log(countByClass(document, 'inner'));
//console.log(findElementByID(document.body, 'first-div-outer'))
//console.log(isCorrect(document, null));
colorizeText(findElementByID(document.body, 'first-div-outer'), 'text', 'red');
