#include <iostream>

using namespace std;

const int MAX_SIZE = 100;

// Finds the scalar product of two arrays.
double scalar_product(double a[], double b[], int size)
{
	double result = 0;

	for (int i = 0; i < size; i++)
	{
		result += a[i] * b[i];
	}

	return result;
}

void input_square_matrix(double A[][MAX_SIZE], int n)
{
	for (int i = 0; i < n; i++)
	{
		for (int j = 0; j < n; j++)
		{
			cin >> A[i][j];
		}
	}
}

int main()
{
	const double eps = 10e-5; // 0.0001;
	double A[MAX_SIZE][MAX_SIZE];
	int n;

	cin >> n;
	input_square_matrix(A, n);

	bool self = true;
	bool others = true;
	for (int i = 0; i < n; i++)
	{
	    // The scalar product of a row with itself.
		double self_product = scalar_product(A[i], A[i], n);
		if (self_product - 1 > eps)
		{
			self = false;
			break;
		}

		for (int k = i + 1; k < n; k++)
		{
		    // The scalar product of a row with each of the other rows.
			double others_product = scalar_product(A[i], A[k], n);
			if (others_product - 0 > eps)
			{
				others = false;
				break;
			}
		}
	}
	// Both conditions are true
	if (self && others)
	{
		cout << "true" << endl;
	}
	else
	{
		cout << "false" << endl;
	}

	return 0;
}
