#include <iostream>

using namespace std;

const int MAX_SIZE = 100;

void input_matrix(int A[][MAX_SIZE], int n, int m)
{
	for (int i = 0; i < n; i++)
	{
		for (int j = 0; j < m; j++)
		{
			cin >> A[i][j];
		}
	}
}

int main()
{
	int A[MAX_SIZE][MAX_SIZE];
	// An array of all the visited elements of the matrix.
	bool visited[MAX_SIZE * MAX_SIZE] = { false };
	int n, m, k;

	cin >> n >> m >> k;
	input_matrix(A, n, m);

	int index = 0;
	int elements_count = n * m;
	int current_i = 0;
	int current_j = 0;
	while (true)
	{
		for (int i = 0; i < elements_count; i++)
		{
			if (!visited[i])
			{
			    // Get the first not visited element.
				index = i;
				break;
			}
		}

        // All elements are visited.
		if (index >= elements_count)
			break;

		while (index < elements_count)
		{
			visited[index] = true;
			current_i = index / m;
			current_j = index % m;
			cout << A[current_i][current_j] << " ";
			index += k;
		}
	}

	return 0;
}
