#include <iostream>

using namespace std;

const int MAX_SIZE = 100;

// Checks whether an element belongs to the array.
bool contains_element(int a[], int size, int x)
{
	for (int i = 0; i < size; i++)
	{
		if (a[i] == x)
			return true;
	}

	return false;
}

void input_matrix(int A[][MAX_SIZE], int n, int m)
{
	for (int i = 0; i < n; i++)
	{
		for (int j = 0; j < m; j++)
		{
			cin >> A[i][j];
		}
	}
}

int main()
{
	int A[MAX_SIZE][MAX_SIZE];
	int n, m;

	cin >> n >> m;
	input_matrix(A, n, m);

	for (int i = 0; i < n; i++)
	{
		for (int k = i + 1; k < n; k++)
		{
			bool similar = true;
			for (int j = 0; j < m; j++)
			{
			    // If the element A[i][j] doesn't belong to the k-th row
			    // then the rows are not similar.
				if (!contains_element(A[k], n, A[i][j]))
				{
					similar = false;
					break;
				}
			}
			if (similar)
			{
				cout << i << " " << k << endl;
			}
		}
	}

	return 0;
}
