#include <iostream>
#include <cstring>

using namespace std;

// Finds the number of values in a string.
int count_vowels(const char* str)
{
	int vowels = 0;
	while (*str)
	{
		if (strchr("aeiou", *str))
		{
			vowels++;
		}
		str++;
	}

	return vowels;
}

// Checks whether a string has exactly 2 vowels.
bool has_two_vowels(const char* str)
{
	return count_vowels(str) == 2;
}

int main()
{
	char input[200];
	cin.getline(input, 200);

	char pref[10];
	cin >> pref;

	// An array of all the words from the input.
	char words[10][50];

	int words_count = 0;
	// Get the first word.
	char* ptr = strtok(input, " ");
	while (ptr)
	{
	    // Store the word in the array.
		strcpy(words[words_count++], ptr);
		// Get the next word.
		ptr = strtok(NULL, " ");
	}

	int pref_length = strlen(pref);
	char result[200] = "";
	for (int i = 0; i < words_count; i++)
	{
	    // The word begins with the prefix and has exactly 2 vowels.
		if (!strncmp(words[i], pref, pref_length) && has_two_vowels(words[i]))
		{
		    // Add the word to the result.
			strcat(result, words[i]);
			// Add a space afterwards.
			strcat(result, " "); // NOTE: This adds an extra space after the last word.
		}
	}
	// Remove the extra space.
	result[strlen(result) - 1] = '\0';

	cout << result << endl;

	return 0;
}
