#include <iostream>
#include <vector>
#include <queue>
#include <stack>

using namespace std;

vector<vector<bool>> matrix;

void generate()
{
   matrix.resize(8);
   for (int i = 0; i < 8; i++)
      matrix[i].resize(8);

   for (int i = 0; i < 8; i++)
   {
      for (int j = 0; j < 8; j++)
         matrix[i][j] = rand() % 2;
   }
}

void print()
{
   for (int i = 0; i < 8; i++)
   {
      for (int j = 0; j < 8; j++)
         cout << matrix[i][j]<< " " ;
      cout << endl;
   }
   cout << endl;
}

void next(int v[])
{
   for (int i = 5; i >= 0; i--)
   {
      if (v[i] == 0)
      {
         v[i] = 1;
         return;
      }
      else if (v[i] == 1)
         v[i] = 0;
   }
}

void flip(int& coin)
{
   coin ^= true;
}

int guess()
{
   int res[] = { 0, 0, 0, 0, 0, 0 };

   int current[] = { 0, 0, 0, 0, 0, 0 };
   for (int i = 0; i < 8; i++)
   {
      for (int j = 0; j < 8; j++)
      {
         if (matrix[i][j])
         {
            for (int k = 0; k < 6; k++)
            {
               (res[k] += current[k]) %= 2;
            }
         }
         next(current);
      }
   }

   return res[5] * 1 + res[4] * 2 + res[3] * 4 + res[2] * 8 + res[1] * 16 + res[0] * 32;
}

int main()
{
   generate();
   print();

   cout << "Choose a coin to flip:" << endl;
   int coin;
   cin >> coin;
   flip(coin);

   print();

   cout << "The key is under: " << guess() << endl;
}