class HerbivoresPopulation {
  final int size;
  int generation;
  float mutationRate;
  float bestLifeTime;
  int deadHerbivores;
  Herbivore[] population;
  ArrayList<Herbivore> matingPool;
  
  HerbivoresPopulation(int tempSize) {
    size = tempSize;
    generation = 1;
    //mutationRate = 0.0065;
    mutationRate = 0.000065;
    matingPool = new ArrayList<Herbivore>();
    population = new Herbivore[size];
    for(int i = 0; i < population.length; i++) {
      population[i] = new Herbivore();
    }
  }
  
  void run() {
    deadHerbivores = 0;
    for(int i = 0; i < population.length; i++) {
      population[i].live();
      if(population[i].isDead) {
        deadHerbivores++;
      }
    }
    if(deadHerbivores == population.length) {
      resetFoods();
      float maximumLifeTime = 0;
      float minimumLifeTime = population[0].lifeTime;
      for(int i = 0; i < population.length; i++) {
        if(population[i].lifeTime > maximumLifeTime) {
          maximumLifeTime = population[i].lifeTime;
        }
        if(population[i].lifeTime < minimumLifeTime) {
          minimumLifeTime = population[i].lifeTime;
        }
        for(int j = 0; j <= (population[i].lifeTime/10)*(population[i].lifeTime/10); j++) {
          matingPool.add(population[i]);
        }
      }
      if(maximumLifeTime > bestLifeTime) {
        bestLifeTime = maximumLifeTime;
        String[] generationWeights = {};
        for(int i = 0; i < population.length; i++) {
          for(int j = 0; j < population[i].brain.layers.length; j++) {
            for(int k = 0; k < population[i].brain.layers[j].neurons.length; k++) {
              for(int l = 0; l < population[i].brain.layers[j].neurons[k].weights.length; l++) {
                generationWeights = (String[]) append(generationWeights, str(population[i].brain.layers[j].neurons[k].weights[l]));
              }
            }
          }
        }
        //saveStrings("G:/Ecosystem_Final/generations/weights for generation " + generation + " with maximum lifetime " + int(maximumLifeTime) + " frames.txt", generationWeights);
      }
      mutationRate = 30/maximumLifeTime;
      for(int i = 0; i < population.length; i++) {
        Herbivore parent1 = matingPool.get(int(random(matingPool.size())));
        Herbivore parent2 = matingPool.get(int(random(matingPool.size())));
        population[i] = new Herbivore();
        population[i].brain = parent1.brain.crossOver(parent2.brain, mutationRate);
      }
      matingPool.clear();
      generation++;
      println("Generation " + generation + " produced. Maximum lifetime for previous generation was " + maximumLifeTime + ". Minimum lifetime for previous generation was " + minimumLifeTime + ".");
    }
  }
  void loadGeneration(String path) {
    String[] weights = loadStrings(path);
    int iterator = 0;
    for(int i = 0; i < population.length; i++) {
      population[i] = new Herbivore();
      for(int j = 0; j < population[i].brain.layers.length; j++) {
        for(int k = 0; k < population[i].brain.layers[j].neurons.length; k++) {
          for(int l = 0; l < population[i].brain.layers[j].neurons[k].weights.length; l++) {
            population[i].brain.layers[j].neurons[k].weights[l] = float(weights[iterator]);
            iterator++;
          }
        }
      }
    }
    if(iterator != weights.length) {
      println("Error! Possibly false loaded generation.");
    }
  }
}
