class Herbivore {
  float x, y, vx, vy, ax, ay,size,damp;
  float health;
  final float maxHealth, healthLoss, healthGained, acceleration, maxVelocity;
  final int foodsDetected = 3;
  boolean isDead;
  int[] closestFoods = new int[foodsDetected];
  float birthFrame;
  float lifeTime;
  Network brain;
  Herbivore() {
    birthFrame = frameCount;
    x=random(width/8,7*width/8);
    y=random(height/8,7*height/8);
    size=20;
    isDead = false;
    maxHealth=100;
    healthGained=maxHealth/6;
    health=maxHealth/2;
    healthLoss=0.1;
    acceleration=0.05;
    damp = 0.99;
    maxVelocity = acceleration/(1-damp);
    brain = new Network();
    brain.addLayer(2*foodsDetected+5,2*foodsDetected+5);
    brain.addLayer(2*foodsDetected+5,2*foodsDetected+5);
    brain.addLayer(2*foodsDetected+5,2);
  }
  
  void live() {
    if(!isDead) {
      health -= healthLoss;
      if(health<0) {
        die();
        return;
      }
      detectClosestFood();
      decide();
      move();
      eatFood();
      display();
    }
  }
  void move() {
    ax *= damp;
    ay *= damp;
    vx += ax;
    vy += ay;
    x += vx;
    y += vy;
    if(x > width+size/2 || x < -size/2 || y > height+size/2 || y < -size/2) {
      die();
    }
  }
  
  void display() {
    noStroke();
    fill(0,0,map(health, 0, maxHealth, 0, 255));
    ellipse(x,y,size,size);
  }
  
  void die() {
    isDead = true;
    lifeTime = frameCount - birthFrame;
  }
  void decide() {
    float[] inputs = new float[2*foodsDetected+5];
    for(int i = 0; i < 2*foodsDetected; i+=2) {
      inputs[i]=map(allFood[closestFoods[i/2]].x, 0, width, -4, 4);
      inputs[i+1]=map(allFood[closestFoods[i/2]].y, 0, height, -4, 4);
      /*if(Float.isNaN(map(allFood[closestFoods[i/2]].x-x, -width, width, -10, 10)) || Float.isNaN(map(allFood[closestFoods[i/2]].y-y, -height, height, -10, 10))) {
        println("fail");
      }*/   
    }
    inputs[2*foodsDetected]=map(health, 0, maxHealth, -4, 4);
    inputs[2*foodsDetected+1]=map(vx, -maxVelocity, maxVelocity, -4, 4);
    inputs[2*foodsDetected+2]=map(vy, -maxVelocity, maxVelocity, -4, 4);
    inputs[2*foodsDetected+3]=map(x, 0, width, -4, 4);
    inputs[2*foodsDetected+4]=map(y, 0, height, -4, 4);
    float[] outputs = brain.produceOutputs(inputs);
    ax = map(outputs[0],-1,1,-acceleration,acceleration);
    ay = map(outputs[1],-1,1,-acceleration,acceleration);
  }
  int[] distanceSort(int[] foods) {
    for(int i = 0; i < foods.length; i++) {
      for(int j = i+1; j < foods.length; j++) {
        if(dist(allFood[foods[i]].x, allFood[foods[i]].y, x, y) > dist(allFood[foods[j]].x, allFood[foods[j]].y, x, y)) {
          int temp = foods[i];
          foods[i]=foods[j];
          foods[j]=temp;
        }
      }
    }
    return foods;
  }
  void eatFood() {
    if(dist(allFood[closestFoods[0]].x, allFood[closestFoods[0]].y, x, y) < size/2 + allFood[closestFoods[0]].size/2) {
      health += healthGained;
      allFood[closestFoods[0]].eaten = true;
      if(health > maxHealth) {
        die();
      }
    }
  }
  void detectClosestFood() {
    for(int i = 0; i < foodsDetected; i++) {
      closestFoods[i] = i;
    }
    closestFoods = distanceSort(closestFoods);
    for(int i = foodsDetected; i < allFood.length; i++) {
      for(int j = foodsDetected-1; j >= 0; j--) {
        if(dist(allFood[i].x, allFood[i].y, x, y) < dist(allFood[closestFoods[j]].x, allFood[closestFoods[j]].y, x, y)) {         
          if(j < foodsDetected-1) {
            closestFoods[j+1] = closestFoods[j];
          }
          closestFoods[j] = i;
        } else {
          break;
        }
      }
    }
  }
}
