class CarnivoresPopulation {
  final int size;
  int generation;
  float mutationRate;
  float maximumFitness;
  float maxGenFitness, minGenFitness;
  int deadCarnivores;
  Carnivore[] population;
  ArrayList<Carnivore> matingPool;
  ArrayList<Carnivore> newMatingPool;
  
  CarnivoresPopulation(int tempSize) {
    size = tempSize;
    generation = 1;
    mutationRate = 0.000065;
    deadCarnivores = 0;
    matingPool = new ArrayList<Carnivore>();
    newMatingPool = new ArrayList<Carnivore>();
    population = new Carnivore[size];
    for(int i = 0; i < population.length; i++) {
      population[i] = new Carnivore();
    }
    loadGeneration("G:/Ecosystem_Final/Ecosystem_Final_Infinite_Move_Through_Walls/CarnivoresPopulations/weights for generation 10289 of carnivores with maximum lifetime 161041 frames.txt");
    for(int i = 0; i < population.length; i++) {
      matingPool.add(population[i]);
    }
  }
  void run() {
    int bestCarnivore = 0;
    for(int i = 0; i < population.length; i++) {
      population[i].live();
      if(frameCount - population[i].birthFrame > frameCount - population[bestCarnivore].birthFrame) {
        bestCarnivore = i;
      }
      if(population[i].isDead) {
        float fitness = calculateFitness(population[i]);
        if(fitness > maxGenFitness) {
          maxGenFitness = fitness;
          if(generation%200==0) {
            population[i].brain.saveNetwork("G:/Ecosystem_Final/Ecosystem_Final_Infinite_Move_Through_Walls/Carnivores/fitness " + maxGenFitness + " generation " + generation + ".txt");
          }
          else if(maxGenFitness > maximumFitness) {
            population[i].brain.saveNetwork("G:/Ecosystem_Final/Ecosystem_Final_Infinite_Move_Through_Walls/Carnivores/fitness " + maxGenFitness + " generation " + generation + ".txt");
          }
        }
        if(fitness < minGenFitness || minGenFitness < 0) {
          minGenFitness = fitness;
        }
        deadCarnivores++;
        for(int j = 0; j <= fitness; j++) {
          newMatingPool.add(population[i]);
        }
        mutationRate = 0.005*(1400/maxGenFitness);
        Carnivore parent1 = matingPool.get(int(random(matingPool.size())));
        Carnivore parent2 = matingPool.get(int(random(matingPool.size())));
        population[i] = new Carnivore();
        population[i].brain = parent1.brain.crossOver(parent2.brain, mutationRate);
      }
    }
    if(deadCarnivores >= population.length) {
      matingPool.clear();
      for(int i = 0; i < newMatingPool.size(); i++) {
        matingPool.add(newMatingPool.get(i));
      }
      newMatingPool.clear();
      generation++;
      if(maxGenFitness > maximumFitness) {
        maximumFitness = maxGenFitness;
        saveGeneration("G:/Ecosystem_Final/Ecosystem_Final_Infinite_Move_Through_Walls/CarnivoresPopulations", maximumFitness);
      }
      else if(generation%150 == 0) {
        saveGeneration("G:/Ecosystem_Final/Ecosystem_Final_Infinite_Move_Through_Walls/CarnivoresPopulations", maximumFitness);
      }
      println("Generation " + generation + " of carnivores produced. Maximum fitness for previous generation was " + maxGenFitness + ". Minimum fitness for previous generation was " + minGenFitness + ".");
      maxGenFitness = 0;
      minGenFitness = -1;
      deadCarnivores = 0;
    }
    stroke(255);
    float intensity = map(population[bestCarnivore].health, 0, population[bestCarnivore].maxHealth, 0, 255);
    fill(intensity, intensity,0);
    ellipse(population[bestCarnivore].x,population[bestCarnivore].y,population[bestCarnivore].size,population[bestCarnivore].size);
    noFill();
    stroke(255,0,0);
    ellipse(population[bestCarnivore].x,population[bestCarnivore].y,population[bestCarnivore].size*4,population[bestCarnivore].size*4);
  }
  
  void saveGeneration(String path, float maximumLifeTime) {
    String[] generationWeights = {};
    for(int i = 0; i < population.length; i++) {
      for(int j = 0; j < population[i].brain.layers.length; j++) {
        for(int k = 0; k < population[i].brain.layers[j].neurons.length; k++) {
          for(int l = 0; l < population[i].brain.layers[j].neurons[k].weights.length; l++) {
            generationWeights = (String[]) append(generationWeights, str(population[i].brain.layers[j].neurons[k].weights[l]));
          }
        }
      }
    }
    saveStrings(path + "/weights for generation " + generation + " of carnivores with maximum lifetime " + int(maximumLifeTime) + " frames.txt", generationWeights);
  }
  void loadGeneration(String path) {
    String[] weights = loadStrings(path);
    int iterator = 0;
    for(int i = 0; i < population.length; i++) {
      population[i] = new Carnivore();
      for(int j = 0; j < population[i].brain.layers.length; j++) {
        for(int k = 0; k < population[i].brain.layers[j].neurons.length; k++) {
          for(int l = 0; l < population[i].brain.layers[j].neurons[k].weights.length; l++) {
            population[i].brain.layers[j].neurons[k].weights[l] = float(weights[iterator]);
            iterator++;
          }
        }
      }
    }
    if(iterator != weights.length) {
      println("Error! Possibly false loaded generation.");
    }
  }
  float calculateFitness(Carnivore c) {
    return(pow(c.lifeTime/10, 2));
  }
}
