class Herbivore {
  float x, y, vx, vy, ax, ay,size,damp;
  float health;
  final float maxHealth, healthLoss, healthGained, acceleration, maxVelocity;
  final int foodsDetected = 3;
  final int carnivoresDetected = 3;
  boolean isDead;
  int[] closestFoods = new int[foodsDetected];
  int[] closestCarnivores = new int[carnivoresDetected];
  float birthFrame;
  float lifeTime;
  Network brain;
  Herbivore() {
    birthFrame = frameCount;
    x=random(size,width-size);
    y=random(size,height-size);
    size=20;
    isDead = false;
    maxHealth=100;
    healthGained=maxHealth/6;
    health=maxHealth/2;
    healthLoss=maxHealth/1000;
    acceleration=0.05;
    damp = 0.99;
    maxVelocity = acceleration/(1-damp);
    brain = new Network();
    brain.addLayer(2*foodsDetected+4*carnivoresDetected+3,foodsDetected+2*carnivoresDetected+3);
    brain.addLayer(foodsDetected+2*carnivoresDetected+3,2);
  }
  
  void live() {
    if(!isDead) {
      health -= healthLoss;
      if(health<0) {
        die();
        return;
      }
      detectClosestFood(allFood);
      decide(allFood, carnivoresPopulation.population);
      move();
      eatFood(allFood);
      display();
    }
  }
  void move() {
    ax *= damp;
    ay *= damp;
    vx += ax;
    vy += ay;
    x += vx;
    y += vy;
    if(x > width+size/2) {
      x=-size/2;
    } else if(x < -size/2) {
      x = width+size/2;
    }
    if(y > height+size/2) {
      y = -size/2;
    } else if(y < -size/2) {
      y = height+size/2;
    }
  }
  
  void display() {
    noStroke();
    fill(0,0,map(health, 0, maxHealth, 0, 255));
    textSize(2*size/3);
    text(int((frameCount-birthFrame))/60,x+size/2,y);
    ellipse(x,y,size,size);
  }
  
  void decide(Food[] tempFoods, Carnivore[] tempCarnivores) {
    float[] inputs = new float[2*foodsDetected+4*carnivoresDetected+3];
    for(int i = 0; i < 2*foodsDetected; i+=2) {
      inputs[i]=map(tempFoods[closestFoods[i/2]].x-x, -width, width, -4, 4);
      inputs[i+1]=map(tempFoods[closestFoods[i/2]].y-y, -height, height, -4, 4);
      /*if(Float.isNaN(map(allFood[closestFoods[i/2]].x-x, -width, width, -10, 10)) || Float.isNaN(map(allFood[closestFoods[i/2]].y-y, -height, height, -10, 10))) {
        println("fail");
      }*/   
    }
    float maxCarnVel = tempCarnivores[0].maxVelocity;
    for(int i = 2*foodsDetected; i < 2*foodsDetected+4*carnivoresDetected; i+=4) {
      inputs[i]=map(tempCarnivores[closestCarnivores[(i-2*foodsDetected)/4]].x-x, -width, width, -4, 4);
      inputs[i+1]=map(tempCarnivores[closestCarnivores[(i-2*foodsDetected)/4]].y-y, -height, height, -4, 4);
      inputs[i+2]=map(tempCarnivores[closestCarnivores[(i-2*foodsDetected)/4]].vx, -maxCarnVel, maxCarnVel, -4, 4);
      inputs[i+3]=map(tempCarnivores[closestCarnivores[(i-2*foodsDetected)/4]].vy, -maxCarnVel, maxCarnVel, -4, 4);
      inputs[i+4]=map(health, 0, maxHealth, -4, 4);
    }
    inputs[2*foodsDetected+4*carnivoresDetected]=map(vx, -maxVelocity, maxVelocity, -4, 4);
    inputs[2*foodsDetected+4*carnivoresDetected+1]=map(vy, -maxVelocity, maxVelocity, -4, 4);
    float[] outputs = brain.produceOutputs(inputs);
    ax = map(outputs[0],-1,1,-acceleration,acceleration);
    ay = map(outputs[1],-1,1,-acceleration,acceleration);
  }
  int[] distanceSortFoods(int[] foods, Food[] tempFoods) {
    for(int i = 0; i < foods.length; i++) {
      for(int j = i+1; j < foods.length; j++) {
        if(dist(tempFoods[foods[i]].x, tempFoods[foods[i]].y, x, y) > dist(tempFoods[foods[j]].x, tempFoods[foods[j]].y, x, y)) {
          int temp = foods[i];
          foods[i]=foods[j];
          foods[j]=temp;
        }
      }
    }
    return foods;
  }
  int[] distanceSortCarnivores(int[] carnivores, Carnivore[] tempCarnivores) {
    for(int i = 0; i < carnivores.length; i++) {
      for(int j = i+1; j < carnivores.length; j++) {
        if(dist(tempCarnivores[carnivores[i]].x, tempCarnivores[carnivores[i]].y, x, y) > dist(tempCarnivores[carnivores[j]].x, tempCarnivores[carnivores[j]].y, x, y)) {
          int temp = carnivores[i];
          carnivores[i]=carnivores[j];
          carnivores[j]=temp;
        }
      }
    }
    return carnivores;
  }
  void eatFood(Food [] tempFoods) {
    if(dist(tempFoods[closestFoods[0]].x, tempFoods[closestFoods[0]].y, x, y) < size/2 + tempFoods[closestFoods[0]].size/2) {
      health += healthGained;
      tempFoods[closestFoods[0]].eaten = true;
      if(health > maxHealth) {
        die();
      }
    }
  }
  void die() {
    isDead = true;
    lifeTime = frameCount - birthFrame;
  }
  void detectClosestFood(Food[] tempFoods) {
    for(int i = 0; i < foodsDetected; i++) {
      closestFoods[i] = i;
    }
    closestFoods = distanceSortFoods(closestFoods, tempFoods);
    for(int i = foodsDetected; i < tempFoods.length; i++) {
      for(int j = foodsDetected-1; j >= 0; j--) {
        if(dist(tempFoods[i].x, tempFoods[i].y, x, y) < dist(tempFoods[closestFoods[j]].x, tempFoods[closestFoods[j]].y, x, y)) {         
          if(j < foodsDetected-1) {
            closestFoods[j+1] = closestFoods[j];
          }
          closestFoods[j] = i;
        } else {
          break;
        }
      }
    }
  }
  void detectClosestCarnivores(Carnivore[] tempCarnivores) {
    for(int i = 0, j = 0; j < carnivoresDetected; i++) {
      if(!tempCarnivores[i].isDead) {
        closestCarnivores[i] = i;
        j++;
      } else {
        i++;
      }
    }
    closestCarnivores = distanceSortCarnivores(closestCarnivores, tempCarnivores);
    for(int i = carnivoresDetected; i < tempCarnivores.length; i++) {
      if(!tempCarnivores[i].isDead) {
        for(int j = carnivoresDetected-1; j >= 0; j--) {
          if(dist(tempCarnivores[i].x, tempCarnivores[i].y, x, y) < dist(tempCarnivores[closestCarnivores[j]].x, tempCarnivores[closestCarnivores[j]].y, x, y)) {         
            if(j < carnivoresDetected-1) {
              closestCarnivores[j+1] = closestCarnivores[j];
            }
            closestCarnivores[j] = i;
          } else {
            break;
          }
        }
      }
    }
  }
}
