class Network {
  Layer[] layers = {};
  float[] outputs = {};
  Network() {
  }
  
  void addLayer(int numberOfInputs, int numberOfNeurons) {
    layers = (Layer[]) append(layers, new Layer(numberOfInputs, numberOfNeurons));
  }
    
  float[] produceOutputs(float[] tempInputs) {
    outputs = layers[0].produceOutputs(tempInputs);
    for(int i = 1; i<layers.length; i++) {
      outputs = layers[i].produceOutputs(outputs);
    }
    return outputs;
  }
  
  Network crossOver(Network b, float mutationRate) {
    Network NN = new Network();
    for(int i = 0; i < layers.length; i++) {
      NN.addLayer(layers[i].neurons[0].numberOfInputs, layers[i].outputs.length);
    }
    for(int i = 0; i < layers.length; i++) {
      for(int j = 0; j < layers[i].neurons.length; j++) {
        for(int k = 0; k < layers[i].neurons[j].weights.length; k++) {
          float check = random(1);
          if(check < mutationRate) {
            float newWeight = random(-1,1);
            NN.layers[i].neurons[j].weights[k] = newWeight;
          } else if(check > 0.5 + mutationRate/2) {
            NN.layers[i].neurons[j].weights[k] = b.layers[i].neurons[j].weights[k];
          } else {
            NN.layers[i].neurons[j].weights[k] = layers[i].neurons[j].weights[k];
          }
        }
      }
    }
    return NN;
  }
  
}
