class Carnivore {
  float x, y, vx, vy, ax, ay, size, damp;
  float health;
  final float maxHealth, minHealthLoss, maxHealthLoss, healthGained, acceleration, maxVelocity;
  float healthLoss;
  final int herbivoresDetected = 3;
  boolean isDead;
  int[] closestHerbivores = new int[herbivoresDetected];
  float birthFrame;
  float lifeTime;
  Network brain;
  
  Carnivore() {
    birthFrame = frameCount;
    x=random(size,width-size);
    y=random(size,height-size);
    vx = 0;
    vy = 0;
    size=30;
    isDead = false;
    maxHealth = 100;
    healthLoss=maxHealth/1000;
    maxHealthLoss = maxHealth/200;
    minHealthLoss = maxHealth/1000;
    healthGained=maxHealth/6;
    health=maxHealth/2;
    acceleration=0.05;
    damp = 0.99;
    maxVelocity = acceleration/(1-damp);
    brain = new Network();
    brain.addLayer(4*herbivoresDetected+3,2*herbivoresDetected+3);
    brain.addLayer(2*herbivoresDetected+3,2);
  }
  
  void live() {
    if(!isDead) {
      healthLoss = map(pow(vx,2)+pow(vy,2),0,pow(maxVelocity,2)+pow(maxVelocity,2),minHealthLoss,maxHealthLoss);
      health -= healthLoss;
      if(health<0) {
        die();
        return;
      }
      detectClosestHerbivores(herbivoresPopulation.population);
      decide(herbivoresPopulation.population);
      move();
      eatHerbivores(herbivoresPopulation.population);
      display();
    }
  }
  
  void decide(Herbivore[] tempHerbivores) {
    float[] inputs = new float[4*herbivoresDetected+3];
    float herbMaxVel = tempHerbivores[0].maxVelocity;
    for(int i = 0; i < 4*herbivoresDetected; i+=4) {
      inputs[i]=map(tempHerbivores[closestHerbivores[i/4]].x-x, -width, width, -4, 4);
      inputs[i+1]=map(tempHerbivores[closestHerbivores[i/4]].y-y, -height, height, -4, 4);
      inputs[i+2]=map(tempHerbivores[closestHerbivores[i/4]].vx, -herbMaxVel, herbMaxVel, -4, 4);
      inputs[i+3]=map(tempHerbivores[closestHerbivores[i/4]].vy, -herbMaxVel, herbMaxVel, -4, 4);
      /*if(Float.isNaN(map(allFood[closestFoods[i/2]].x-x, -width, width, -10, 10)) || Float.isNaN(map(allFood[closestFoods[i/2]].y-y, -height, height, -10, 10))) {
        println("fail");
      }*/   
    }
    inputs[4*herbivoresDetected]=map(health, 0, maxHealth, -4, 4);
    inputs[4*herbivoresDetected+1]=map(vx, -maxVelocity, maxVelocity, -4, 4);
    inputs[4*herbivoresDetected+2]=map(vy, -maxVelocity, maxVelocity, -4, 4);
    float[] outputs = brain.produceOutputs(inputs);
    ax = map(outputs[0],-1,1,-acceleration,acceleration);
    ay = map(outputs[1],-1,1,-acceleration,acceleration);
  }
  
  void move() {
    ax *= damp;
    ay *= damp;
    vx += ax;
    vy += ay;
    x += vx;
    y += vy;
    if(x > width+size/2) {
      x=-size/2;
    } else if(x < -size/2) {
      x = width+size/2;
    }
    if(y > height+size/2) {
      y = -size/2;
    } else if(y < -size/2) {
      y = height+size/2;
    }
  }
  void display() {
    noStroke();
    fill(map(health, 0, maxHealth, 0, 255), 0, 0);
    textSize(2*size/3);
    text(int((frameCount-birthFrame))/60,x+size/2,y);
    ellipse(x,y,size,size);
  }
  void die() {
    isDead = true;
    lifeTime = frameCount - birthFrame;
  }
  int[] distanceSort(int[] herbivores, Herbivore[] tempHerbivores) {
    for(int i = 0; i < herbivores.length; i++) {
      for(int j = i+1; j < herbivores.length; j++) {
        if(dist(tempHerbivores[herbivores[i]].x, tempHerbivores[herbivores[i]].y, x, y) > dist(tempHerbivores[herbivores[j]].x, tempHerbivores[herbivores[j]].y, x, y)) {
          int temp = herbivores[i];
          herbivores[i]=herbivores[j];
          herbivores[j]=temp;
        }
      }
    }
    return herbivores;
  }
  void detectClosestHerbivores(Herbivore[] tempHerbivores) {
    for(int i = 0, j = 0; j < herbivoresDetected; i++) {
      if(!tempHerbivores[i].isDead) {
        closestHerbivores[j] = i;
        j++;
      }
    }
    closestHerbivores = distanceSort(closestHerbivores, tempHerbivores);
    for(int i = herbivoresDetected; i < tempHerbivores.length; i++) {
      if(!tempHerbivores[i].isDead) {
        for(int j = herbivoresDetected-1; j >= 0; j--) {
          if(dist(tempHerbivores[i].x, tempHerbivores[i].y, x, y) < dist(tempHerbivores[closestHerbivores[j]].x, tempHerbivores[closestHerbivores[j]].y, x, y)) {         
            if(j < herbivoresDetected-1) {
              closestHerbivores[j+1] = closestHerbivores[j];
            }
            closestHerbivores[j] = i;
          } else {
            break;
          }
        }
      }
    }
  }
  void eatHerbivores(Herbivore [] tempHerbivores) {
    if(dist(tempHerbivores[closestHerbivores[0]].x, tempHerbivores[closestHerbivores[0]].y, x, y) < size/2 + tempHerbivores[closestHerbivores[0]].size/2) {
      health += healthGained;
      if(health > maxHealth) {
        health = maxHealth;
      }
      tempHerbivores[closestHerbivores[0]].die();
    }
  }
}
