class HerbivoresPopulation {
  final int size;
  int generation;
  float mutationRate;
  float maximumFitness;
  float maxGenFitness, minGenFitness;
  int deadHerbivores;
  int uselessHerbivores;
  Herbivore[] population;
  ArrayList<Herbivore> matingPool;
  ArrayList<Herbivore> newMatingPool;
  
  HerbivoresPopulation(int tempSize) {
    size = tempSize;
    generation = 1;
    deadHerbivores = 0;
    uselessHerbivores = 0;
    //mutationRate = 0.0065;
    mutationRate = 0.000065;
    matingPool = new ArrayList<Herbivore>();
    newMatingPool = new ArrayList<Herbivore>();
    population = new Herbivore[size];
    for(int i = 0; i < population.length; i++) {
      population[i] = new Herbivore();
    }
    loadGeneration("G:/Ecosystem_Final/Ecosystem_Final_Infinite_Move_Through_Walls/HerbivoresPopulations/weights for generation 27600 of herbivores with maximum fitness 80315.txt");
    for(int i = 0; i < population.length; i++) {
      matingPool.add(population[i]);
    }
  }
  
  void run() {
    int bestHerbivore = 0;
    for(int i = 0; i < population.length; i++) {
      population[i].live();
      if(frameCount - population[i].birthFrame > frameCount - population[bestHerbivore].birthFrame) {
        bestHerbivore = i;
      }
      if(population[i].isDead) {
        float fitness = calculateFitness(population[i]);
        if(fitness > maxGenFitness) {
          maxGenFitness = fitness;
          if(generation%300==0) {
            population[i].brain.saveNetwork("G:/Ecosystem_Final/Ecosystem_Final_Infinite_Move_Through_Walls/Herbivores/fitness " + maxGenFitness + " generation " + generation + ".txt");
          }
          else if(maxGenFitness > maximumFitness) {
            population[i].brain.saveNetwork("G:/Ecosystem_Final/Ecosystem_Final_Infinite_Move_Through_Walls/Herbivores/fitness " + maxGenFitness + " generation " + generation + ".txt");
          }
        }
        if(fitness < minGenFitness || minGenFitness < 0) {
          minGenFitness = fitness;
        }
        if(int(fitness) == 0) {
          uselessHerbivores++;
        }
        deadHerbivores++;
        for(int j = 0; j <= fitness; j++) {
          newMatingPool.add(population[i]);
        }
        mutationRate = 0.005*(1000/maxGenFitness);
        Herbivore parent1 = matingPool.get(int(random(matingPool.size())));
        Herbivore parent2 = matingPool.get(int(random(matingPool.size())));
        population[i] = new Herbivore();
        population[i].brain = parent1.brain.crossOver(parent2.brain, mutationRate);
      }
    }
    if(deadHerbivores >= population.length) {
      matingPool.clear();
      for(int i = 0; i < newMatingPool.size(); i++) {
        matingPool.add(newMatingPool.get(i));
      }
      newMatingPool.clear();
      generation++;
      if(maxGenFitness > maximumFitness) {
        maximumFitness = maxGenFitness;
        saveGeneration("G:/Ecosystem_Final/Ecosystem_Final_Infinite_Move_Through_Walls/HerbivoresPopulations", maximumFitness);
      } else if(generation%300 == 0) {
        saveGeneration("G:/Ecosystem_Final/Ecosystem_Final_Infinite_Move_Through_Walls/HerbivoresPopulations", maximumFitness);
      }
      println("Generation " + generation + " of herbivores produced. Maximum fitness for previous generation was " + maxGenFitness + ". Minimum fitness for previous generation was " + minGenFitness + ".");
      println("Generation had " + uselessHerbivores + " useless herbivores.");
      uselessHerbivores=0;
      maxGenFitness = 0;
      minGenFitness = -1;
      deadHerbivores = 0;
    }
    float intensity = map(population[bestHerbivore].health, 0, population[bestHerbivore].maxHealth, 0, 255);
    noStroke();
    fill(intensity, intensity,intensity);
    ellipse(population[bestHerbivore].x,population[bestHerbivore].y,population[bestHerbivore].size,population[bestHerbivore].size);
    noFill();
    strokeWeight(5);
    stroke(0,0,255);
    ellipse(population[bestHerbivore].x,population[bestHerbivore].y,population[bestHerbivore].size*4,population[bestHerbivore].size*4);
  }
  
  void saveGeneration(String path, float maximumLifeTime) {
    String[] generationWeights = {};
    for(int i = 0; i < population.length; i++) {
      for(int j = 0; j < population[i].brain.layers.length; j++) {
        for(int k = 0; k < population[i].brain.layers[j].neurons.length; k++) {
          for(int l = 0; l < population[i].brain.layers[j].neurons[k].weights.length; l++) {
            generationWeights = (String[]) append(generationWeights, str(population[i].brain.layers[j].neurons[k].weights[l]));
          }
        }
      }
    }
    saveStrings(path + "/weights for generation " + generation + " of herbivores with maximum fitness " + int(maximumLifeTime) + ".txt", generationWeights);
  }
  void loadGeneration(String path) {
    String[] weights = loadStrings(path);
    int iterator = 0;
    for(int i = 0; i < population.length; i++) {
      population[i] = new Herbivore();
      for(int j = 0; j < population[i].brain.layers.length; j++) {
        for(int k = 0; k < population[i].brain.layers[j].neurons.length; k++) {
          for(int l = 0; l < population[i].brain.layers[j].neurons[k].weights.length; l++) {
            population[i].brain.layers[j].neurons[k].weights[l] = float(weights[iterator]);
            iterator++;
          }
        }
      }
    }
    if(iterator != weights.length) {
      println("Error! Possibly false loaded generation.");
    }
  }
  float calculateFitness(Herbivore h) {
    return(pow(h.lifeTime/10, 2));
  }
}
