#include <iostream>
#include <vector>

using namespace std;


void swap(int &x, int &y) {
    int z = x;
    x = y;
    y = z;
}

struct RMQ_table {
    vector<vector<int> > m;
    vector<int> log2;

    void build_table(const vector<int>& a) {
        int n = a.size();
        log2.resize(n+1);
        log2[1] = 0;
        for(int i = 2; i <= n; i++)
            log2[i] = log2[i/2] + 1;
        int k = log2[n];
        m.assign(n, vector<int>(n));
        for(int i = 0; i < n; i++)
            m[i][0] = i;
        for(int j = 1; j <= k; j++){
            for(int i = 0; i+(1<<j) <= n; i++){
                int p = m[i][j-1];
                int r = m[i+(1<<(j-1))][j-1];
                m[i][j] = (a[p]<a[r]) ? p : r;
            }
        }
    }
    
    int find_min(int x, int y, const vector<int>& a) {
        // This vector must be the vector used by build_table.
        if (x > y) swap(x, y);
        int j = log2[y - x + 1];
        int p = m[x][j];
        int r = m[y-(1<<j)+1][j];
        return (a[p]<a[r]) ? p : r;
    }
};

struct LCA_tree {
    int tree_root;
    vector<vector<int> > tree;
    vector<int> depth, traverse, traverse_depth, vertex_indexes;
    RMQ_table table_RMQ;

    void build_tree() {
        int n;
        cin >> n; // number of vertices
        cin >> tree_root; // root
        tree.resize(n);
        for(int i = 0; i < n - 1; i++){
            int x, y;
            cin >> x >> y; // edge (x ; y)
            tree[x].push_back(y);
        }
    }

    void DFS(int v, int d = 0) {
        depth[v] = d;
        traverse.push_back(v);
        traverse_depth.push_back(depth[v]);
        if(vertex_indexes[v] == -1) vertex_indexes[v] = traverse.size() - 1;
        for(int i = 0; i < tree[v].size(); i++){
            int u = tree[v][i];
            if(depth[u] == -1){
                DFS(u, d + 1);
                traverse.push_back(v);
                traverse_depth.push_back(d);
            }
        }
    }

    void traverse_tree() {
        int n = tree.size();
        depth.assign(n, -1);
        vertex_indexes.assign(n, -1);
        DFS(tree_root);
    }

    void prepare_for_LCA() {
        traverse_tree();
        table_RMQ.build_table(traverse_depth);
    }

    int get_LCA(int x, int y) {
        int i = vertex_indexes[x];
        int j = vertex_indexes[y];
        int z = table_RMQ.find_min(i, j, traverse_depth);
        return traverse[z];
    }

};


int main() {
    LCA_tree t;
    t.build_tree();
    t.prepare_for_LCA();
    while (true) {
      int x, y;
      cin >> x >> y;
      if (x < 0 || y < 0) break;
      cout << t.get_LCA(x, y) << endl;
    }
    return 0;
}
