#include <bits/stdc++.h>
using namespace std;
mt19937 rng;


double func1(double x, double y){
    return (pow(x-2, 2) + pow(y-1, 2));
}

double func2(double x){
    return pow(x,4) - 2*pow(x,3) -15*pow(x,2) + x + 2; //(pow(x, 2) + 3*x + 1) * exp (abs(x));
}

double accept(double z, double minim, double T){
    double p = -(z - minim) /T;
    return exp(p);
}



void simmulatedAnnealingOneVar(double a, double b, double (*func)(double)){
    uniform_real_distribution<> udist(0, 1);
    uniform_real_distribution<> dist(a, b);
    int numIterations = 10000;
    double x = dist(rng);
    double xm = x;
    double T = 1;
    double tF = 0.0001;
    double alpha = 0.99;
    double minim = func(x);
    double z;
    while (T>tF) {
        int i=1;
        x=xm;
        while(i<=numIterations) {
            x=x+udist(rng)-0.5;
            z=func(x);
            if (z<minim || (accept(z,minim,T)>(udist(rng)))) {
                minim=z;
                xm=x;
            }
            i=i+1;
        }
        T=T*alpha;
    }
    cout<<"min: "<<minim<<" x: "<<xm<<endl;

}



void simmulatedAnnealingTwoVar(double a, double b, double (*func)(double,double)){
    uniform_real_distribution<> udist(0, 1);
    uniform_real_distribution<> dist(a, b);
    int numIterations = 10000;
    double x = dist(rng);
    double y = dist(rng);
    double xm = x, ym=y;
    double tI = 1;
    double tF = 0.0001;
    double alpha = 0.99;
    double T = tI;
    double minim = func(x, y);
    double z;
    while (T>tF) {
        int i=1;
        x=xm;
        y=ym;
        while(i<=numIterations) {
            x=x+udist(rng)-0.5;
            y=y+udist(rng)-0.5;
            z=func(x,y);
            if (z<minim || (accept(z,minim,T)>(udist(rng)))) {
                minim=z;
                xm=x;
                ym=y;
            }
            i=i+1;
        }
        T=T*alpha;
    }
    cout<<"min: "<<minim<<" x: "<<xm<<" y: "<<ym<<endl;

}

int main(){
    rng.seed(chrono::high_resolution_clock::now().time_since_epoch().count());
    simmulatedAnnealingTwoVar(-10000,10000,func1);
    simmulatedAnnealingOneVar(-10000,10000,func2);
    return 0;
}
