#include <bits/stdc++.h>
using namespace std;
mt19937 rng;

const double DOUBLE_MAX = 1.7976931348623157E+308;

struct Solution{
    int k;
    double cost;
    int config[256];
    Solution(int,double,int*);
    Solution(const Solution&);
    Solution& operator= (const Solution&);

};

Solution::Solution(int k_ = 0 ,double cost_ = DOUBLE_MAX ,int* config_ = NULL):cost(cost_),k(k_){
    for(int i=0;i<k;i++)
        config[i]=config_[i];
}

Solution::Solution(const Solution &other):cost(other.cost),k(other.k){
    for(int i=0;i<k;i++)
        config[i]=other.config[i];
}

Solution& Solution::operator= (const Solution &other){
    cost=other.cost;
    k=other.k;
    for(int i=0;i<k;i++)
        config[i]=other.config[i];
    return *this;
}

Solution neighbor(Solution &sol,int M,int N){
    uniform_int_distribution<mt19937::result_type> d(1,5);
    int arr[256];
    for(int i=0;i<sol.k;i++){
        int temp = d(rng);
        if(temp == 1){
            if(sol.config[i]+1>=M*N)
                arr[i]=sol.config[i];
            else
                arr[i]=sol.config[i]+1;
        }
        else if(temp == 2){
            if(sol.config[i]-1 < 0)
                arr[i]=sol.config[i];
            else
                arr[i]=sol.config[i]-1;
        }
        else if(temp == 3){
            if(sol.config[i]- N < 0)
                arr[i]=sol.config[i];
            else
                arr[i]=sol.config[i]-N;
        }
        else if( temp == 4){
            if(sol.config[i]+N>=M*N)
                arr[i]=sol.config[i];
            else
                arr[i]=sol.config[i]+N;
        }
        else arr[i]=sol.config[i];

    }
    return Solution(sol.k,-1,arr);
}

Solution genRandomSol(int k, int M, int N){
    int a[256];
    uniform_int_distribution<mt19937::result_type> dist(0,M*N-1);
    for(int i=0;i<k;i++)
        a[i]= dist(rng);

    return  Solution(k,-1,a);
}

int costFunc(const Solution &sol, int M, int N){
    bool used[256][256]={};
    for(int i=0;i<sol.k;i++)
        used[sol.config[i]%M][sol.config[i]/M] = 1;
    int cnt=0;

    for(int i=0;i<M;i++){
        bool flag = false;
        for(int j=0;j<N;j++){
            if(used[i][j])
                flag=true;
            cnt+=used[i][j];
        }
        if(flag)
            cnt--;
    }
    for(int i=0;i<N;i++){
        bool flag = false;
        for(int j=0;j<M;j++){
            if(used[j][i])
                flag=true;
            cnt+=used[j][i];
        }
        if(flag)
            cnt--;
    }
    return cnt;
}

double accept(double z, double minim, double T){
    double p = -(z - minim) /T;
    return exp(p);
}

/// Problem: place k objects in an MxN target
/// plane yielding minimal cost according to
/// defined objective function

void print(Solution &sol, int M,int N){
    cout<<sol.cost<<endl;
    string grid[M];
    for(int i=0;i<M;i++){
        grid[i].append(N,'-');
    }
    for(int i=0;i<sol.k;i++)
        grid[sol.config[i]%M][sol.config[i]/M] = 'X';

    for(int i=0;i<M;i++)
       cout<<grid[i]<<endl;
    /*
    for(int i=0;i<sol.k;i++)
        cout<<sol.config[i]<<' ';
    cout<<endl;
        */

}

Solution gotin(int k,int M,int N){
    int arr[256] = {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19};
    return Solution(20,-1,arr);

}


void simmulatedAnnealing(int k,int M,int N){
    uniform_real_distribution<> udist(0, 1);
    double T = 1;
    double Tmin = 0.0001;
    double alpfa = 0.99;
    int numIterations = 100;
    Solution currSol= genRandomSol(k,M,N);
    currSol.cost = costFunc(currSol,M,N);
    Solution minn = currSol;
    cout<<minn.cost<<endl;
    string grid2[M];
    for(int i=0;i<M;i++){
        grid2[i].append(N,'-');
    }
    for(int i=0;i<k;i++)
        grid2[minn.config[i]%M][minn.config[i]/M] = 'X';

    for(int i=0;i<M;i++)
       cout<<grid2[i]<<endl;


    while (T > Tmin) {
        currSol = minn;
        for (int i=0;i<numIterations;i++){
                currSol = neighbor(currSol,M,N);
                currSol.cost = costFunc(currSol,M,N);
                if (currSol.cost < minn.cost || accept(currSol.cost,minn.cost,T) > (udist(rng))) {
                    minn = currSol;
                }

            }

            T =  T*alpfa;
        }

    cout<<endl;
    print(minn,M,N);
}



int main() {
    rng.seed(chrono::high_resolution_clock::now().time_since_epoch().count());
    simmulatedAnnealing(20,20,20);
    return 0;
}
