// Metropolis-Hastings.cpp : This file contains the 'main' function. Program execution begins and ends there.
//

#include <iostream>
#include <random>
#include <cmath>
#include <fstream>

using namespace std;

double test_function(double x)
{
    if (x < 0)
    {
        return 0;
    }
    else if (x > 5)
    {
        return 0;
    }
    else
    {
        return log(x)*cos(x) + 2;
    }
}

void MH_Algo(vector<double>& markov_chain, double start_val, int samples)
{
    default_random_engine generator1;
    default_random_engine generator2;

    normal_distribution<double> N_distribution(0, 1);
    uniform_real_distribution<double> U_distribution(0, 1);

    double current_X = start_val;
    double current_Y = test_function(current_X);

    markov_chain.push_back(current_X);

    for (int i = 0; i < samples; ++i)
    {
        double number = N_distribution(generator1);
        //cout << number << " ";
        double next_X = current_X + number;
        double next_Y = test_function(next_X);

        //cout << next_X << " " << next_Y << endl;
        double A = next_Y / current_Y;

        if (A >= 1 || U_distribution(generator2) < A)
        {
            //cout << current_X;
            current_X = next_X;
            current_Y = next_Y;
        }
        //else just keep the values unchanged!
        
        markov_chain.push_back(current_X);
    }
}

int main()
{
    //empty vector with 10000 elements, meaning we will sample 10000 elements with their respective probabilities from the 
    //curve in the interval
    vector<double> visited_markov_chain_states;

    //fill the vector
    MH_Algo(visited_markov_chain_states, 3, 100000);

    //write to file
    ofstream oFile("output.txt");
    for (const double &a : visited_markov_chain_states)
    {
        oFile << a << " ";
    }
    oFile.close();
}
